/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.expressions;

import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;

public class And
implements Expression {
    private final Expression left;
    private final Expression right;

    And(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    @Override
    public Expression.Operation op() {
        return Expression.Operation.AND;
    }

    @Override
    public boolean isEquivalentTo(Expression expr) {
        if (expr.op() == Expression.Operation.AND) {
            And other = (And)expr;
            return this.left.isEquivalentTo(other.left()) && this.right.isEquivalentTo(other.right()) || this.left.isEquivalentTo(other.right()) && this.right.isEquivalentTo(other.left());
        }
        return false;
    }

    @Override
    public Expression negate() {
        return Expressions.or(this.left.negate(), this.right.negate());
    }

    public String toString() {
        return String.format("(%s and %s)", this.left, this.right);
    }
}

