/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.expressions;

import com.dataiku.dss.shadelib.org.apache.iceberg.Accessor;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundTerm;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Reference;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import java.util.Locale;

public class BoundReference<T>
implements BoundTerm<T>,
Reference<T> {
    private final Types.NestedField field;
    private final Accessor<StructLike> accessor;
    private final String name;

    BoundReference(Types.NestedField field, Accessor<StructLike> accessor, String name) {
        this.field = field;
        this.accessor = accessor;
        this.name = name;
    }

    @Override
    public T eval(StructLike struct) {
        return (T)this.accessor.get(struct);
    }

    public Types.NestedField field() {
        return this.field;
    }

    @Override
    public BoundReference<T> ref() {
        return this;
    }

    @Override
    public Type type() {
        return this.field.type();
    }

    @Override
    public boolean producesNull() {
        return this.field.isOptional();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isEquivalentTo(BoundTerm<?> other) {
        if (other instanceof BoundReference) {
            Types.NestedField otherField = ((BoundReference)other).field();
            return this.field.fieldId() == otherField.fieldId() && this.field.type().equals(otherField.type()) && this.field.isOptional() == otherField.isOptional();
        }
        return other.isEquivalentTo(this);
    }

    public int fieldId() {
        return this.field.fieldId();
    }

    public Accessor<StructLike> accessor() {
        return this.accessor;
    }

    public String toString() {
        return String.format(Locale.ROOT, "ref(id=%d, accessor-type=%s)", this.field.fieldId(), this.accessor.type());
    }
}

