/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.expressions;

import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundReference;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundTerm;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Transform;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SerializableFunction;

public class BoundTransform<S, T>
implements BoundTerm<T> {
    private final BoundReference<S> ref;
    private final Transform<S, T> transform;
    private final SerializableFunction<S, T> func;

    BoundTransform(BoundReference<S> ref, Transform<S, T> transform) {
        this.ref = ref;
        this.transform = transform;
        this.func = transform.bind(ref.type());
    }

    @Override
    public T eval(StructLike struct) {
        return (T)this.func.apply(this.ref.eval(struct));
    }

    @Override
    public BoundReference<S> ref() {
        return this.ref;
    }

    public Transform<S, T> transform() {
        return this.transform;
    }

    @Override
    public boolean producesNull() {
        return this.ref.producesNull() || !this.transform.preservesOrder();
    }

    @Override
    public Type type() {
        return this.transform.getResultType(this.ref.type());
    }

    @Override
    public boolean isEquivalentTo(BoundTerm<?> other) {
        if (other instanceof BoundTransform) {
            BoundTransform bound = (BoundTransform)other;
            return this.ref.isEquivalentTo(bound.ref()) && this.transform.equals(bound.transform());
        }
        if (this.transform.isIdentity() && other instanceof BoundReference) {
            return this.ref.isEquivalentTo(other);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.transform) + "(" + String.valueOf(this.ref) + ")";
    }
}

