/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.expressions;

import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundPredicate;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundTerm;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.NaNUtil;

public class BoundUnaryPredicate<T>
extends BoundPredicate<T> {
    BoundUnaryPredicate(Expression.Operation op, BoundTerm<T> term) {
        super(op, term);
    }

    @Override
    public Expression negate() {
        return new BoundUnaryPredicate<T>(this.op().negate(), (BoundTerm)this.term());
    }

    @Override
    public boolean isUnaryPredicate() {
        return true;
    }

    @Override
    public BoundUnaryPredicate<T> asUnaryPredicate() {
        return this;
    }

    @Override
    public boolean test(T value) {
        switch (this.op()) {
            case IS_NULL: {
                return value == null;
            }
            case NOT_NULL: {
                return value != null;
            }
            case IS_NAN: {
                return NaNUtil.isNaN(value);
            }
            case NOT_NAN: {
                return !NaNUtil.isNaN(value);
            }
        }
        throw new IllegalStateException("Invalid operation for BoundUnaryPredicate: " + String.valueOf((Object)this.op()));
    }

    @Override
    public boolean isEquivalentTo(Expression other) {
        if (this.op() == other.op()) {
            return ((BoundTerm)this.term()).isEquivalentTo((BoundTerm)((BoundUnaryPredicate)other).term());
        }
        return false;
    }

    public String toString() {
        switch (this.op()) {
            case IS_NULL: {
                return "is_null(" + String.valueOf(this.term()) + ")";
            }
            case NOT_NULL: {
                return "not_null(" + String.valueOf(this.term()) + ")";
            }
            case IS_NAN: {
                return "is_nan(" + String.valueOf(this.term()) + ")";
            }
            case NOT_NAN: {
                return "not_nan(" + String.valueOf(this.term()) + ")";
            }
        }
        return "Invalid unary predicate: operation = " + String.valueOf((Object)this.op());
    }
}

