/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.expressions;

import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Binder;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Bound;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ExpressionVisitors;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Literal;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.NaNUtil;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Set;

public class Evaluator
implements Serializable {
    private final Expression expr;

    public Evaluator(Types.StructType struct, Expression unbound) {
        this.expr = Binder.bind(struct, unbound, true);
    }

    public Evaluator(Types.StructType struct, Expression unbound, boolean caseSensitive) {
        this.expr = Binder.bind(struct, unbound, caseSensitive);
    }

    public boolean eval(StructLike data) {
        return new EvalVisitor().eval(data);
    }

    private class EvalVisitor
    extends ExpressionVisitors.BoundVisitor<Boolean> {
        private StructLike struct;

        private EvalVisitor() {
        }

        private boolean eval(StructLike row) {
            this.struct = row;
            return ExpressionVisitors.visitEvaluator(Evaluator.this.expr, this);
        }

        @Override
        public Boolean alwaysTrue() {
            return true;
        }

        @Override
        public Boolean alwaysFalse() {
            return false;
        }

        @Override
        public Boolean not(Boolean result) {
            return result == false;
        }

        @Override
        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        @Override
        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        @Override
        public <T> Boolean isNull(Bound<T> valueExpr) {
            return valueExpr.eval(this.struct) == null;
        }

        @Override
        public <T> Boolean notNull(Bound<T> valueExpr) {
            return valueExpr.eval(this.struct) != null;
        }

        @Override
        public <T> Boolean isNaN(Bound<T> valueExpr) {
            return NaNUtil.isNaN(valueExpr.eval(this.struct));
        }

        @Override
        public <T> Boolean notNaN(Bound<T> valueExpr) {
            return !NaNUtil.isNaN(valueExpr.eval(this.struct));
        }

        @Override
        public <T> Boolean lt(Bound<T> valueExpr, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(valueExpr.eval(this.struct), lit.value()) < 0;
        }

        @Override
        public <T> Boolean ltEq(Bound<T> valueExpr, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(valueExpr.eval(this.struct), lit.value()) <= 0;
        }

        @Override
        public <T> Boolean gt(Bound<T> valueExpr, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(valueExpr.eval(this.struct), lit.value()) > 0;
        }

        @Override
        public <T> Boolean gtEq(Bound<T> valueExpr, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(valueExpr.eval(this.struct), lit.value()) >= 0;
        }

        @Override
        public <T> Boolean eq(Bound<T> valueExpr, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(valueExpr.eval(this.struct), lit.value()) == 0;
        }

        @Override
        public <T> Boolean notEq(Bound<T> valueExpr, Literal<T> lit) {
            return !((Boolean)this.eq((Bound)valueExpr, (Literal)lit)).booleanValue();
        }

        @Override
        public <T> Boolean in(Bound<T> valueExpr, Set<T> literalSet) {
            return literalSet.contains(valueExpr.eval(this.struct));
        }

        @Override
        public <T> Boolean notIn(Bound<T> valueExpr, Set<T> literalSet) {
            return !((Boolean)this.in((Bound)valueExpr, (Set)literalSet)).booleanValue();
        }

        @Override
        public <T> Boolean startsWith(Bound<T> valueExpr, Literal<T> lit) {
            T evalRes = valueExpr.eval(this.struct);
            return evalRes != null && ((String)evalRes).startsWith((String)lit.value());
        }

        @Override
        public <T> Boolean notStartsWith(Bound<T> valueExpr, Literal<T> lit) {
            return !((Boolean)this.startsWith((Bound)valueExpr, (Literal)lit)).booleanValue();
        }
    }
}

