/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.expressions;

import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Literal;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.SerializationProxies;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.io.BaseEncoding;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Comparators;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Conversions;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ByteBuffers;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.DateTimeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.NaNUtil;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;

class Literals {
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    private Literals() {
    }

    static <T> Literal<T> from(T value) {
        Preconditions.checkNotNull(value, "Cannot create expression literal from null");
        Preconditions.checkArgument(!NaNUtil.isNaN(value), "Cannot create expression literal from NaN");
        if (value instanceof Literal) {
            return (Literal)value;
        }
        if (value instanceof Boolean) {
            return new BooleanLiteral((Boolean)value);
        }
        if (value instanceof Integer) {
            return new IntegerLiteral((Integer)value);
        }
        if (value instanceof Long) {
            return new LongLiteral((Long)value);
        }
        if (value instanceof Float) {
            return new FloatLiteral((Float)value);
        }
        if (value instanceof Double) {
            return new DoubleLiteral((Double)value);
        }
        if (value instanceof CharSequence) {
            return new StringLiteral((CharSequence)value);
        }
        if (value instanceof UUID) {
            return new UUIDLiteral((UUID)value);
        }
        if (value instanceof byte[]) {
            return new FixedLiteral(ByteBuffer.wrap((byte[])value));
        }
        if (value instanceof ByteBuffer) {
            return new BinaryLiteral((ByteBuffer)value);
        }
        if (value instanceof BigDecimal) {
            return new DecimalLiteral((BigDecimal)value);
        }
        throw new IllegalArgumentException(String.format("Cannot create expression literal from %s: %s", value.getClass().getName(), value));
    }

    static <T> AboveMax<T> aboveMax() {
        return AboveMax.INSTANCE;
    }

    static <T> BelowMin<T> belowMin() {
        return BelowMin.INSTANCE;
    }

    static class BooleanLiteral
    extends ComparableLiteral<Boolean> {
        BooleanLiteral(Boolean value) {
            super(value);
        }

        @Override
        public <T> Literal<T> to(Type type) {
            if (type.typeId() == Type.TypeID.BOOLEAN) {
                return this;
            }
            return null;
        }

        @Override
        protected Type.TypeID typeId() {
            return Type.TypeID.BOOLEAN;
        }
    }

    static class IntegerLiteral
    extends ComparableLiteral<Integer> {
        IntegerLiteral(Integer value) {
            super(value);
        }

        @Override
        public <T> Literal<T> to(Type type) {
            switch (type.typeId()) {
                case INTEGER: {
                    return this;
                }
                case LONG: {
                    return new LongLiteral(((Integer)this.value()).longValue());
                }
                case FLOAT: {
                    return new FloatLiteral(Float.valueOf(((Integer)this.value()).floatValue()));
                }
                case DOUBLE: {
                    return new DoubleLiteral(((Integer)this.value()).doubleValue());
                }
                case DATE: {
                    return new DateLiteral((Integer)this.value());
                }
                case DECIMAL: {
                    int scale = ((Types.DecimalType)type).scale();
                    return new DecimalLiteral(BigDecimal.valueOf(((Integer)this.value()).intValue()).setScale(scale, RoundingMode.HALF_UP));
                }
            }
            return null;
        }

        @Override
        protected Type.TypeID typeId() {
            return Type.TypeID.INTEGER;
        }
    }

    static class LongLiteral
    extends ComparableLiteral<Long> {
        LongLiteral(Long value) {
            super(value);
        }

        @Override
        public <T> Literal<T> to(Type type) {
            switch (type.typeId()) {
                case INTEGER: {
                    if (Integer.MAX_VALUE < (Long)this.value()) {
                        return Literals.aboveMax();
                    }
                    if (Integer.MIN_VALUE > (Long)this.value()) {
                        return Literals.belowMin();
                    }
                    return new IntegerLiteral(((Long)this.value()).intValue());
                }
                case LONG: {
                    return this;
                }
                case FLOAT: {
                    return new FloatLiteral(Float.valueOf(((Long)this.value()).floatValue()));
                }
                case DOUBLE: {
                    return new DoubleLiteral(((Long)this.value()).doubleValue());
                }
                case TIME: {
                    return new TimeLiteral((Long)this.value());
                }
                case TIMESTAMP: {
                    return new TimestampLiteral((Long)this.value());
                }
                case TIMESTAMP_NANO: {
                    return new TimestampLiteral((Long)this.value()).to(type);
                }
                case DATE: {
                    if (Integer.MAX_VALUE < (Long)this.value()) {
                        return Literals.aboveMax();
                    }
                    if (Integer.MIN_VALUE > (Long)this.value()) {
                        return Literals.belowMin();
                    }
                    return new DateLiteral(((Long)this.value()).intValue());
                }
                case DECIMAL: {
                    int scale = ((Types.DecimalType)type).scale();
                    return new DecimalLiteral(BigDecimal.valueOf((Long)this.value()).setScale(scale, RoundingMode.HALF_UP));
                }
            }
            return null;
        }

        @Override
        protected Type.TypeID typeId() {
            return Type.TypeID.LONG;
        }
    }

    static class FloatLiteral
    extends ComparableLiteral<Float> {
        FloatLiteral(Float value) {
            super(value);
        }

        @Override
        public <T> Literal<T> to(Type type) {
            switch (type.typeId()) {
                case FLOAT: {
                    return this;
                }
                case DOUBLE: {
                    return new DoubleLiteral(((Float)this.value()).doubleValue());
                }
                case DECIMAL: {
                    int scale = ((Types.DecimalType)type).scale();
                    return new DecimalLiteral(BigDecimal.valueOf(((Float)this.value()).floatValue()).setScale(scale, RoundingMode.HALF_UP));
                }
            }
            return null;
        }

        @Override
        protected Type.TypeID typeId() {
            return Type.TypeID.FLOAT;
        }
    }

    static class DoubleLiteral
    extends ComparableLiteral<Double> {
        DoubleLiteral(Double value) {
            super(value);
        }

        @Override
        public <T> Literal<T> to(Type type) {
            switch (type.typeId()) {
                case FLOAT: {
                    if (3.4028234663852886E38 < (Double)this.value()) {
                        return Literals.aboveMax();
                    }
                    if (-3.4028234663852886E38 > (Double)this.value()) {
                        return Literals.belowMin();
                    }
                    return new FloatLiteral(Float.valueOf(((Double)this.value()).floatValue()));
                }
                case DOUBLE: {
                    return this;
                }
                case DECIMAL: {
                    int scale = ((Types.DecimalType)type).scale();
                    return new DecimalLiteral(BigDecimal.valueOf((Double)this.value()).setScale(scale, RoundingMode.HALF_UP));
                }
            }
            return null;
        }

        @Override
        protected Type.TypeID typeId() {
            return Type.TypeID.DOUBLE;
        }
    }

    static class StringLiteral
    extends BaseLiteral<CharSequence> {
        private static final Comparator<CharSequence> CMP = Comparators.nullsFirst().thenComparing(Comparators.charSequences());

        StringLiteral(CharSequence value) {
            super(value);
        }

        @Override
        public <T> Literal<T> to(Type type) {
            switch (type.typeId()) {
                case DATE: {
                    int date = (int)ChronoUnit.DAYS.between(EPOCH_DAY, LocalDate.parse((CharSequence)this.value(), DateTimeFormatter.ISO_LOCAL_DATE));
                    return new DateLiteral(date);
                }
                case TIME: {
                    long timeMicros = LocalTime.parse((CharSequence)this.value(), DateTimeFormatter.ISO_LOCAL_TIME).toNanoOfDay() / 1000L;
                    return new TimeLiteral(timeMicros);
                }
                case TIMESTAMP: {
                    if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                        long timestampMicros = DateTimeUtil.isoTimestamptzToMicros(((CharSequence)this.value()).toString());
                        return new TimestampLiteral(timestampMicros);
                    }
                    long timestampMicros = DateTimeUtil.isoTimestampToMicros(((CharSequence)this.value()).toString());
                    return new TimestampLiteral(timestampMicros);
                }
                case TIMESTAMP_NANO: {
                    if (((Types.TimestampNanoType)type).shouldAdjustToUTC()) {
                        return new TimestampNanoLiteral(DateTimeUtil.isoTimestamptzToNanos((CharSequence)this.value()));
                    }
                    return new TimestampNanoLiteral(DateTimeUtil.isoTimestampToNanos((CharSequence)this.value()));
                }
                case STRING: {
                    return this;
                }
                case UUID: {
                    return new UUIDLiteral(UUID.fromString(((CharSequence)this.value()).toString()));
                }
                case DECIMAL: {
                    BigDecimal decimal = new BigDecimal(((CharSequence)this.value()).toString());
                    return new DecimalLiteral(decimal);
                }
            }
            return null;
        }

        @Override
        public Comparator<CharSequence> comparator() {
            return CMP;
        }

        @Override
        protected Type.TypeID typeId() {
            return Type.TypeID.STRING;
        }

        @Override
        public String toString() {
            return "\"" + String.valueOf(this.value()) + "\"";
        }
    }

    static class UUIDLiteral
    extends ComparableLiteral<UUID> {
        UUIDLiteral(UUID value) {
            super(value);
        }

        @Override
        public <T> Literal<T> to(Type type) {
            if (type.typeId() == Type.TypeID.UUID) {
                return this;
            }
            return null;
        }

        @Override
        protected Type.TypeID typeId() {
            return Type.TypeID.UUID;
        }
    }

    static class FixedLiteral
    extends BaseLiteral<ByteBuffer> {
        private static final Comparator<ByteBuffer> CMP = Comparators.nullsFirst().thenComparing(Comparators.unsignedBytes());

        FixedLiteral(ByteBuffer value) {
            super(value);
        }

        @Override
        public <T> Literal<T> to(Type type) {
            switch (type.typeId()) {
                case FIXED: {
                    Types.FixedType fixed = (Types.FixedType)type;
                    if (((ByteBuffer)this.value()).remaining() == fixed.length()) {
                        return this;
                    }
                    return null;
                }
                case BINARY: {
                    return new BinaryLiteral((ByteBuffer)this.value());
                }
            }
            return null;
        }

        @Override
        public Comparator<ByteBuffer> comparator() {
            return CMP;
        }

        @Override
        protected Type.TypeID typeId() {
            return Type.TypeID.FIXED;
        }

        Object writeReplace() throws ObjectStreamException {
            return new SerializationProxies.FixedLiteralProxy((ByteBuffer)this.value());
        }

        @Override
        public String toString() {
            byte[] bytes = ByteBuffers.toByteArray((ByteBuffer)this.value());
            return "X'" + BaseEncoding.base16().encode(bytes) + "'";
        }
    }

    static class BinaryLiteral
    extends BaseLiteral<ByteBuffer> {
        private static final Comparator<ByteBuffer> CMP = Comparators.nullsFirst().thenComparing(Comparators.unsignedBytes());

        BinaryLiteral(ByteBuffer value) {
            super(value);
        }

        @Override
        public <T> Literal<T> to(Type type) {
            switch (type.typeId()) {
                case FIXED: {
                    Types.FixedType fixed = (Types.FixedType)type;
                    if (((ByteBuffer)this.value()).remaining() == fixed.length()) {
                        return new FixedLiteral((ByteBuffer)this.value());
                    }
                    return null;
                }
                case BINARY: {
                    return this;
                }
            }
            return null;
        }

        @Override
        public Comparator<ByteBuffer> comparator() {
            return CMP;
        }

        Object writeReplace() throws ObjectStreamException {
            return new SerializationProxies.BinaryLiteralProxy((ByteBuffer)this.value());
        }

        @Override
        protected Type.TypeID typeId() {
            return Type.TypeID.BINARY;
        }

        @Override
        public String toString() {
            byte[] bytes = ByteBuffers.toByteArray((ByteBuffer)this.value());
            return "X'" + BaseEncoding.base16().encode(bytes) + "'";
        }
    }

    static class DecimalLiteral
    extends ComparableLiteral<BigDecimal> {
        DecimalLiteral(BigDecimal value) {
            super(value);
        }

        @Override
        public <T> Literal<T> to(Type type) {
            switch (type.typeId()) {
                case DECIMAL: {
                    return this;
                }
            }
            return null;
        }

        @Override
        protected Type.TypeID typeId() {
            return Type.TypeID.DECIMAL;
        }
    }

    static class AboveMax<T>
    implements Literal<T> {
        private static final AboveMax INSTANCE = new AboveMax();

        private AboveMax() {
        }

        @Override
        public T value() {
            throw new UnsupportedOperationException("AboveMax has no value");
        }

        @Override
        public <X> Literal<X> to(Type type) {
            throw new UnsupportedOperationException("Cannot change the type of AboveMax");
        }

        @Override
        public Comparator<T> comparator() {
            throw new UnsupportedOperationException("AboveMax has no comparator");
        }

        public String toString() {
            return "aboveMax";
        }
    }

    static class BelowMin<T>
    implements Literal<T> {
        private static final BelowMin INSTANCE = new BelowMin();

        private BelowMin() {
        }

        @Override
        public T value() {
            throw new UnsupportedOperationException("BelowMin has no value");
        }

        @Override
        public <X> Literal<X> to(Type type) {
            throw new UnsupportedOperationException("Cannot change the type of BelowMin");
        }

        @Override
        public Comparator<T> comparator() {
            throw new UnsupportedOperationException("BelowMin has no comparator");
        }

        public String toString() {
            return "belowMin";
        }
    }

    static class TimestampNanoLiteral
    extends ComparableLiteral<Long> {
        TimestampNanoLiteral(Long value) {
            super(value);
        }

        @Override
        public <T> Literal<T> to(Type type) {
            switch (type.typeId()) {
                case DATE: {
                    return new DateLiteral(DateTimeUtil.nanosToDays((Long)this.value()));
                }
                case TIMESTAMP: {
                    return new TimestampLiteral(DateTimeUtil.nanosToMicros((Long)this.value()));
                }
                case TIMESTAMP_NANO: {
                    return this;
                }
            }
            return null;
        }

        @Override
        protected Type.TypeID typeId() {
            return Type.TypeID.TIMESTAMP_NANO;
        }
    }

    static class TimestampLiteral
    extends ComparableLiteral<Long> {
        TimestampLiteral(Long value) {
            super(value);
        }

        @Override
        public <T> Literal<T> to(Type type) {
            switch (type.typeId()) {
                case TIMESTAMP: {
                    return this;
                }
                case DATE: {
                    return new DateLiteral(DateTimeUtil.microsToDays((Long)this.value()));
                }
                case TIMESTAMP_NANO: {
                    return new TimestampNanoLiteral(DateTimeUtil.microsToNanos((Long)this.value()));
                }
            }
            return null;
        }

        @Override
        protected Type.TypeID typeId() {
            return Type.TypeID.TIMESTAMP;
        }
    }

    static class TimeLiteral
    extends ComparableLiteral<Long> {
        TimeLiteral(Long value) {
            super(value);
        }

        @Override
        public <T> Literal<T> to(Type type) {
            if (type.typeId() == Type.TypeID.TIME) {
                return this;
            }
            return null;
        }

        @Override
        protected Type.TypeID typeId() {
            return Type.TypeID.TIME;
        }
    }

    static class DateLiteral
    extends ComparableLiteral<Integer> {
        DateLiteral(Integer value) {
            super(value);
        }

        @Override
        public <T> Literal<T> to(Type type) {
            if (type.typeId() == Type.TypeID.DATE) {
                return this;
            }
            return null;
        }

        @Override
        protected Type.TypeID typeId() {
            return Type.TypeID.DATE;
        }
    }

    private static abstract class ComparableLiteral<C extends Comparable<C>>
    extends BaseLiteral<C> {
        private static final Comparator<? extends Comparable> CMP = Comparators.nullsFirst().thenComparing(Comparator.naturalOrder());

        ComparableLiteral(C value) {
            super(value);
        }

        @Override
        public Comparator<C> comparator() {
            return CMP;
        }
    }

    private static abstract class BaseLiteral<T>
    implements Literal<T> {
        private final T value;
        private volatile transient ByteBuffer byteBuffer = null;

        BaseLiteral(T value) {
            Preconditions.checkNotNull(value, "Literal values cannot be null");
            this.value = value;
        }

        @Override
        public T value() {
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final ByteBuffer toByteBuffer() {
            if (this.byteBuffer == null) {
                BaseLiteral baseLiteral = this;
                synchronized (baseLiteral) {
                    if (this.byteBuffer == null) {
                        this.byteBuffer = Conversions.toByteBuffer(this.typeId(), this.value());
                    }
                }
            }
            return this.byteBuffer;
        }

        protected abstract Type.TypeID typeId();

        public String toString() {
            return String.valueOf(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            BaseLiteral that = (BaseLiteral)other;
            return this.comparator().compare(this.value(), that.value()) == 0;
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }
    }
}

