/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.expressions;

import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundAggregate;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundTerm;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ValueAggregate;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Comparators;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Conversions;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import java.util.Comparator;

public class MaxAggregate<T>
extends ValueAggregate<T> {
    private final int fieldId;
    private final Type.PrimitiveType type;
    private final Comparator<T> comparator;

    protected MaxAggregate(BoundTerm<T> term) {
        super(Expression.Operation.MAX, term);
        Types.NestedField field = term.ref().field();
        this.fieldId = field.fieldId();
        this.type = field.type().asPrimitiveType();
        this.comparator = Comparators.forType(this.type);
    }

    @Override
    protected boolean hasValue(DataFile file) {
        boolean hasBound = this.safeContainsKey(file.upperBounds(), this.fieldId);
        Long valueCount = this.safeGet(file.valueCounts(), this.fieldId);
        Long nullCount = this.safeGet(file.nullValueCounts(), this.fieldId);
        boolean boundAllNull = valueCount != null && valueCount > 0L && nullCount != null && nullCount.longValue() == valueCount.longValue();
        return hasBound || boundAllNull;
    }

    @Override
    protected Object evaluateRef(DataFile file) {
        return Conversions.fromByteBuffer(this.type, this.safeGet(file.upperBounds(), this.fieldId));
    }

    @Override
    public BoundAggregate.Aggregator<T> newAggregator() {
        return new MaxAggregator<T>(this, this.comparator);
    }

    private static class MaxAggregator<T>
    extends BoundAggregate.NullSafeAggregator<T, T> {
        private final Comparator<T> comparator;
        private T max = null;

        MaxAggregator(MaxAggregate<T> aggregate, Comparator<T> comparator) {
            super(aggregate);
            this.comparator = comparator;
        }

        @Override
        protected void update(T value) {
            if (this.max == null || this.comparator.compare(value, this.max) > 0) {
                this.max = value;
            }
        }

        @Override
        protected T current() {
            return this.max;
        }
    }
}

