/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.expressions;

import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Splitter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Streams;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PathUtil {
    private static final String RFC9535_NAME_FIRST = "[A-Za-z_\\x{0080}-\\x{D7FF}\\x{E000}-\\x{10FFFF}]";
    private static final String RFC9535_NAME_CHARS = "[0-9A-Za-z_\\x{0080}-\\x{D7FF}\\x{E000}-\\x{10FFFF}]*";
    private static final Predicate<String> RFC9535_MEMBER_NAME_SHORTHAND = Pattern.compile("[A-Za-z_\\x{0080}-\\x{D7FF}\\x{E000}-\\x{10FFFF}][0-9A-Za-z_\\x{0080}-\\x{D7FF}\\x{E000}-\\x{10FFFF}]*").asMatchPredicate();
    private static final Pattern RFC9535_REQUIRES_ESCAPE = Pattern.compile("[^\\x{0020}-\\x{0026}\\x{0028}-\\x{005B}\\x{005D}-\\x{D7FF}\\x{E000}-\\x{10FFFF}]");
    private static final Map<Character, String> RFC9535_ESCAPE_REPLACEMENTS = PathUtil.buildReplacementMap();
    private static final Splitter DOT = Splitter.on(".");
    private static final String ROOT = "$";

    private PathUtil() {
    }

    static List<String> parse(String path) {
        Preconditions.checkArgument(path != null, "Invalid path: null");
        Preconditions.checkArgument(!path.contains("[") && !path.contains("]"), "Unsupported path, contains bracket: %s", (Object)path);
        Preconditions.checkArgument(!path.contains("*"), "Unsupported path, contains wildcard: %s", (Object)path);
        Preconditions.checkArgument(!path.contains(".."), "Unsupported path, contains recursive descent: %s", (Object)path);
        List<String> parts = DOT.splitToList(path);
        Preconditions.checkArgument(ROOT.equals(parts.get(0)), "Invalid path, does not start with %s: %s", (Object)ROOT, (Object)path);
        List<String> names = parts.subList(1, parts.size());
        for (String name : names) {
            Preconditions.checkArgument(RFC9535_MEMBER_NAME_SHORTHAND.test(name), "Invalid path: %s (%s has invalid characters)", (Object)path, (Object)name);
        }
        return names;
    }

    public static String toNormalizedPath(Iterable<String> fields) {
        return ROOT + Streams.stream(fields).map(PathUtil::rfc9535escape).map(name -> "['" + name + "']").collect(Collectors.joining(""));
    }

    @VisibleForTesting
    static String rfc9535escape(String name) {
        StringBuilder builder = new StringBuilder();
        Matcher matcher = RFC9535_REQUIRES_ESCAPE.matcher(name);
        while (matcher.find()) {
            matcher.appendReplacement(builder, PathUtil.replacement(matcher.group()));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    private static String replacement(String esc) {
        String replacement = RFC9535_ESCAPE_REPLACEMENTS.get(Character.valueOf(esc.charAt(0)));
        if (replacement != null) {
            return replacement;
        }
        throw new IllegalArgumentException("Cannot escape for normalized path: " + esc);
    }

    private static Map<Character, String> buildReplacementMap() {
        ImmutableMap.Builder<Character, String> builder = ImmutableMap.builder();
        builder.put(Character.valueOf('\b'), "\\\\b");
        builder.put(Character.valueOf('\t'), "\\\\t");
        builder.put(Character.valueOf('\f'), "\\\\f");
        builder.put(Character.valueOf('\n'), "\\\\n");
        builder.put(Character.valueOf('\r'), "\\\\r");
        builder.put(Character.valueOf('\''), "\\\\'");
        builder.put(Character.valueOf('\\'), "\\\\\\\\");
        Set<Character> specialEscapeChars = Set.of(Character.valueOf('\b'), Character.valueOf('\t'), Character.valueOf('\f'), Character.valueOf('\n'), Character.valueOf('\r'));
        for (char ch = '\u0000'; ch <= '\u001f'; ch = (char)(ch + '\u0001')) {
            if (specialEscapeChars.contains(Character.valueOf(ch))) continue;
            builder.put(Character.valueOf(ch), String.format("\\\\u%04x", ch));
        }
        return builder.build();
    }
}

