/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.expressions;

import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.ValidationException;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundExtract;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundReference;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundTerm;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.NamedReference;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.PathUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.UnboundTerm;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;

public class UnboundExtract<T>
implements UnboundTerm<T> {
    private final NamedReference<?> ref;
    private final String path;
    private final Type.PrimitiveType type;

    public UnboundExtract(NamedReference<?> ref, String path, String type) {
        this.ref = ref;
        this.path = path;
        this.type = Types.fromPrimitiveString(type);
        PathUtil.parse(path);
    }

    @Override
    public BoundTerm<T> bind(Types.StructType struct, boolean caseSensitive) {
        Object boundRef = this.ref.bind(struct, caseSensitive);
        ValidationException.check(Types.VariantType.get().equals(((BoundReference)boundRef).type()), "Cannot bind extract, not a variant: %s", ((BoundReference)boundRef).name());
        ValidationException.check(!this.type.equals(Types.UnknownType.get()), "Invalid type to extract: unknown", new Object[0]);
        return new BoundExtract((BoundReference<?>)boundRef, this.path, this.type);
    }

    @Override
    public NamedReference<?> ref() {
        return this.ref;
    }

    public String path() {
        return this.path;
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        return "extract(" + String.valueOf(this.ref) + ", path=" + this.path + ", type=" + String.valueOf(this.type) + ")";
    }
}

