/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.hadoop;

import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.ValidationException;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIOMetricsContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.Counter;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsContext;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import org.apache.hadoop.fs.FileSystem;

public class HadoopMetricsContext
implements FileIOMetricsContext {
    public static final String SCHEME = "io.metrics-scheme";
    private String scheme;
    private volatile transient FileSystem.Statistics statistics;

    public HadoopMetricsContext(String scheme) {
        ValidationException.check(scheme != null, "Scheme is required for Hadoop FileSystem metrics reporting", new Object[0]);
        this.scheme = scheme;
    }

    @Override
    public void initialize(Map<String, String> properties) {
        this.scheme = properties.getOrDefault(SCHEME, this.scheme);
        this.statistics = FileSystem.getStatistics((String)this.scheme, null);
    }

    @Override
    public <T extends Number> MetricsContext.Counter<T> counter(String name, Class<T> type, MetricsContext.Unit unit) {
        switch (name) {
            case "read.bytes": {
                ValidationException.check(type == Long.class, "'%s' requires Long type", "read.bytes");
                return this.longCounter(arg_0 -> ((FileSystem.Statistics)this.statistics()).incrementBytesRead(arg_0));
            }
            case "read.operations": {
                ValidationException.check(type == Integer.class, "'%s' requires Integer type", "read.operations");
                return this.integerCounter(arg_0 -> ((FileSystem.Statistics)this.statistics()).incrementReadOps(arg_0));
            }
            case "write.bytes": {
                ValidationException.check(type == Long.class, "'%s' requires Long type", "write.bytes");
                return this.longCounter(arg_0 -> ((FileSystem.Statistics)this.statistics()).incrementBytesWritten(arg_0));
            }
            case "write.operations": {
                ValidationException.check(type == Integer.class, "'%s' requires Integer type", "write.operations");
                return this.integerCounter(arg_0 -> ((FileSystem.Statistics)this.statistics()).incrementWriteOps(arg_0));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported counter: '%s'", name));
    }

    private MetricsContext.Counter<Long> longCounter(final Consumer<Long> consumer) {
        return new MetricsContext.Counter<Long>(){

            @Override
            public void increment() {
                this.increment(1L);
            }

            @Override
            public void increment(Long amount) {
                consumer.accept(amount);
            }
        };
    }

    private MetricsContext.Counter<Integer> integerCounter(final Consumer<Integer> consumer) {
        return new MetricsContext.Counter<Integer>(){

            @Override
            public void increment() {
                this.increment(1);
            }

            @Override
            public void increment(Integer amount) {
                consumer.accept(amount);
            }
        };
    }

    @Override
    public Counter counter(String name, MetricsContext.Unit unit) {
        switch (name) {
            case "read.bytes": {
                return this.counter(arg_0 -> ((FileSystem.Statistics)this.statistics()).incrementBytesRead(arg_0), () -> ((FileSystem.Statistics)this.statistics()).getBytesRead());
            }
            case "read.operations": {
                return this.counter((long x) -> this.statistics.incrementReadOps((int)x), () -> ((FileSystem.Statistics)this.statistics()).getReadOps());
            }
            case "write.bytes": {
                return this.counter(arg_0 -> ((FileSystem.Statistics)this.statistics()).incrementBytesWritten(arg_0), () -> ((FileSystem.Statistics)this.statistics()).getBytesWritten());
            }
            case "write.operations": {
                return this.counter((long x) -> this.statistics.incrementWriteOps((int)x), () -> ((FileSystem.Statistics)this.statistics()).getWriteOps());
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported counter: '%s'", name));
    }

    private Counter counter(final LongConsumer consumer, final LongSupplier supplier) {
        return new Counter(){

            @Override
            public void increment() {
                this.increment(1L);
            }

            @Override
            public void increment(long amount) {
                consumer.accept(amount);
            }

            @Override
            public long value() {
                return supplier.getAsLong();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem.Statistics statistics() {
        if (this.statistics == null) {
            HadoopMetricsContext hadoopMetricsContext = this;
            synchronized (hadoopMetricsContext) {
                if (this.statistics == null) {
                    this.statistics = FileSystem.getStatistics((String)this.scheme, null);
                }
            }
        }
        return this.statistics;
    }
}

