/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.hadoop;

import com.dataiku.dss.shadelib.org.apache.iceberg.CatalogUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.LocationProviders;
import com.dataiku.dss.shadelib.org.apache.iceberg.LockManager;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadataParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionManager;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.CommitFailedException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.RuntimeIOException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.ValidationException;
import com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.Util;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.LocationProvider;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopTableOperations
implements TableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopTableOperations.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("v([^\\.]*)\\..*");
    private static final TableMetadataParser.Codec[] TABLE_METADATA_PARSER_CODEC_VALUES = TableMetadataParser.Codec.values();
    private final Configuration conf;
    private final Path location;
    private final FileIO fileIO;
    private final LockManager lockManager;
    private volatile TableMetadata currentMetadata = null;
    private volatile Integer version = null;
    private volatile boolean shouldRefresh = true;

    protected HadoopTableOperations(Path location, FileIO fileIO, Configuration conf, LockManager lockManager) {
        this.conf = conf;
        this.location = location;
        this.fileIO = fileIO;
        this.lockManager = lockManager;
    }

    @Override
    public TableMetadata current() {
        if (this.shouldRefresh) {
            return this.refresh();
        }
        return this.currentMetadata;
    }

    private synchronized Pair<Integer, TableMetadata> versionAndMetadata() {
        return Pair.of(this.version, this.currentMetadata);
    }

    private synchronized void updateVersionAndMetadata(int newVersion, String metadataFile) {
        if (this.version == null || this.version != newVersion) {
            this.version = newVersion;
            this.currentMetadata = HadoopTableOperations.checkUUID(this.currentMetadata, TableMetadataParser.read(this.io(), metadataFile));
        }
    }

    @Override
    public TableMetadata refresh() {
        int ver = this.version != null ? this.version.intValue() : this.findVersion();
        try {
            Path metadataFile = this.getMetadataFile(ver);
            if (this.version == null && metadataFile == null && ver == 0) {
                return null;
            }
            if (metadataFile == null) {
                throw new ValidationException("Metadata file for version %d is missing under %s", ver, this.metadataRoot());
            }
            Path nextMetadataFile = this.getMetadataFile(ver + 1);
            while (nextMetadataFile != null) {
                metadataFile = nextMetadataFile;
                nextMetadataFile = this.getMetadataFile(++ver + 1);
            }
            this.updateVersionAndMetadata(ver, metadataFile.toString());
            this.shouldRefresh = false;
            return this.currentMetadata;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to refresh the table", new Object[0]);
        }
    }

    @Override
    public void commit(TableMetadata base, TableMetadata metadata) {
        Pair<Integer, TableMetadata> current = this.versionAndMetadata();
        if (base != current.second()) {
            throw new CommitFailedException("Cannot commit changes based on stale table metadata", new Object[0]);
        }
        if (base == metadata) {
            LOG.info("Nothing to commit.");
            return;
        }
        Preconditions.checkArgument(base == null || base.location().equals(metadata.location()), "Hadoop path-based tables cannot be relocated");
        Preconditions.checkArgument(!metadata.properties().containsKey("write.metadata.path"), "Hadoop path-based tables cannot relocate metadata");
        String codecName = metadata.property("write.metadata.compression-codec", "none");
        TableMetadataParser.Codec codec = TableMetadataParser.Codec.fromName(codecName);
        String fileExtension = TableMetadataParser.getFileExtension(codec);
        Path tempMetadataFile = this.metadataPath(String.valueOf(UUID.randomUUID()) + fileExtension);
        TableMetadataParser.write(metadata, this.io().newOutputFile(tempMetadataFile.toString()));
        int nextVersion = (current.first() != null ? current.first() : 0) + 1;
        Path finalMetadataFile = this.metadataFilePath(nextVersion, codec);
        FileSystem fs = this.getFileSystem(tempMetadataFile, this.conf);
        this.renameToFinal(fs, tempMetadataFile, finalMetadataFile, nextVersion);
        LOG.info("Committed a new metadata file {}", (Object)finalMetadataFile);
        this.writeVersionHint(nextVersion);
        CatalogUtil.deleteRemovedMetadataFiles(this.io(), base, metadata);
        this.shouldRefresh = true;
    }

    @Override
    public FileIO io() {
        return this.fileIO;
    }

    @Override
    public LocationProvider locationProvider() {
        return LocationProviders.locationsFor(this.current().location(), this.current().properties());
    }

    @Override
    public String metadataFileLocation(String fileName) {
        return this.metadataPath(fileName).toString();
    }

    @Override
    public TableOperations temp(final TableMetadata uncommittedMetadata) {
        return new TableOperations(){

            @Override
            public TableMetadata current() {
                return uncommittedMetadata;
            }

            @Override
            public TableMetadata refresh() {
                throw new UnsupportedOperationException("Cannot call refresh on temporary table operations");
            }

            @Override
            public void commit(TableMetadata base, TableMetadata metadata) {
                throw new UnsupportedOperationException("Cannot call commit on temporary table operations");
            }

            @Override
            public String metadataFileLocation(String fileName) {
                return HadoopTableOperations.this.metadataFileLocation(fileName);
            }

            @Override
            public LocationProvider locationProvider() {
                return LocationProviders.locationsFor(uncommittedMetadata.location(), uncommittedMetadata.properties());
            }

            @Override
            public FileIO io() {
                return HadoopTableOperations.this.io();
            }

            @Override
            public EncryptionManager encryption() {
                return HadoopTableOperations.this.encryption();
            }

            @Override
            public long newSnapshotId() {
                return HadoopTableOperations.this.newSnapshotId();
            }
        };
    }

    @VisibleForTesting
    Path getMetadataFile(int metadataVersion) throws IOException {
        for (TableMetadataParser.Codec codec : TABLE_METADATA_PARSER_CODEC_VALUES) {
            Path metadataFile = this.metadataFilePath(metadataVersion, codec);
            FileSystem fs = this.getFileSystem(metadataFile, this.conf);
            if (fs.exists(metadataFile)) {
                return metadataFile;
            }
            if (!codec.equals((Object)TableMetadataParser.Codec.GZIP) || !(fs = this.getFileSystem(metadataFile = this.oldMetadataFilePath(metadataVersion, codec), this.conf)).exists(metadataFile)) continue;
            return metadataFile;
        }
        return null;
    }

    private Path metadataFilePath(int metadataVersion, TableMetadataParser.Codec codec) {
        return this.metadataPath("v" + metadataVersion + TableMetadataParser.getFileExtension(codec));
    }

    private Path oldMetadataFilePath(int metadataVersion, TableMetadataParser.Codec codec) {
        return this.metadataPath("v" + metadataVersion + TableMetadataParser.getOldFileExtension(codec));
    }

    private Path metadataPath(String filename) {
        return new Path(this.metadataRoot(), filename);
    }

    private Path metadataRoot() {
        return new Path(this.location, "metadata");
    }

    private int version(String fileName) {
        Matcher matcher = VERSION_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            return -1;
        }
        String versionNumber = matcher.group(1);
        try {
            return Integer.parseInt(versionNumber);
        }
        catch (NumberFormatException ne) {
            return -1;
        }
    }

    @VisibleForTesting
    Path versionHintFile() {
        return this.metadataPath("version-hint.text");
    }

    private void writeVersionHint(int versionToWrite) {
        Path versionHintFile = this.versionHintFile();
        FileSystem fs = this.getFileSystem(versionHintFile, this.conf);
        try {
            Path tempVersionHintFile = this.metadataPath(String.valueOf(UUID.randomUUID()) + "-version-hint.temp");
            this.writeVersionToPath(fs, tempVersionHintFile, versionToWrite);
            fs.delete(versionHintFile, false);
            fs.rename(tempVersionHintFile, versionHintFile);
        }
        catch (IOException e) {
            LOG.warn("Failed to update version hint", (Throwable)e);
        }
    }

    private void writeVersionToPath(FileSystem fs, Path path, int versionToWrite) throws IOException {
        try (FSDataOutputStream out = fs.create(path, false);){
            out.write(String.valueOf(versionToWrite).getBytes(StandardCharsets.UTF_8));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    int findVersion() {
        Path versionHintFile = this.versionHintFile();
        FileSystem fs = this.getFileSystem(versionHintFile, this.conf);
        try (InputStreamReader fsr = new InputStreamReader((InputStream)fs.open(versionHintFile), StandardCharsets.UTF_8);){
            int n;
            try (BufferedReader in = new BufferedReader(fsr);){
                n = Integer.parseInt(in.readLine().replace("\n", ""));
            }
            return n;
        }
        catch (Exception e) {
            try {
                if (!fs.exists(this.metadataRoot())) {
                    LOG.debug("Metadata for table not found in directory {}", (Object)this.metadataRoot(), (Object)e);
                    return 0;
                }
                LOG.warn("Error reading version hint file {}", (Object)versionHintFile, (Object)e);
                FileStatus[] files = fs.listStatus(this.metadataRoot(), name -> VERSION_PATTERN.matcher(name.getName()).matches());
                int maxVersion = 0;
                for (FileStatus file : files) {
                    int currentVersion = this.version(file.getPath().getName());
                    if (currentVersion <= maxVersion || this.getMetadataFile(currentVersion) == null) continue;
                    maxVersion = currentVersion;
                }
                return maxVersion;
            }
            catch (IOException io) {
                LOG.warn("Error trying to recover the latest version number for {}", (Object)versionHintFile, (Object)io);
                return 0;
            }
        }
    }

    private void renameToFinal(FileSystem fs, Path src, Path dst, int nextVersion) {
        try {
            if (!this.lockManager.acquire(dst.toString(), src.toString())) {
                throw new CommitFailedException("Failed to acquire lock on file: %s with owner: %s", dst, src);
            }
            if (fs.exists(dst)) {
                CommitFailedException cfe = new CommitFailedException("Version %d already exists: %s", nextVersion, dst);
                RuntimeException re = this.tryDelete(src);
                if (re != null) {
                    cfe.addSuppressed(re);
                }
                throw cfe;
            }
            if (!fs.rename(src, dst)) {
                CommitFailedException cfe = new CommitFailedException("Failed to commit changes using rename: %s", dst);
                RuntimeException re = this.tryDelete(src);
                if (re != null) {
                    cfe.addSuppressed(re);
                }
                throw cfe;
            }
        }
        catch (IOException e) {
            CommitFailedException cfe = new CommitFailedException(e, "Failed to commit changes using rename: %s", dst);
            RuntimeException re = this.tryDelete(src);
            if (re != null) {
                cfe.addSuppressed(re);
            }
            throw cfe;
        }
        finally {
            if (!this.lockManager.release(dst.toString(), src.toString())) {
                LOG.warn("Failed to release lock on file: {} with owner: {}", (Object)dst, (Object)src);
            }
        }
    }

    private RuntimeException tryDelete(Path path) {
        try {
            this.io().deleteFile(path.toString());
            return null;
        }
        catch (RuntimeException re) {
            return re;
        }
    }

    protected FileSystem getFileSystem(Path path, Configuration hadoopConf) {
        return Util.getFs(path, hadoopConf);
    }

    private static TableMetadata checkUUID(TableMetadata currentMetadata, TableMetadata newMetadata) {
        String newUUID = newMetadata.uuid();
        if (currentMetadata != null && currentMetadata.uuid() != null && newUUID != null) {
            Preconditions.checkState(newUUID.equals(currentMetadata.uuid()), "Table UUID does not match: current=%s != refreshed=%s", (Object)currentMetadata.uuid(), (Object)newUUID);
        }
        return newMetadata;
    }
}

