/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.hive;

import com.dataiku.dss.shadelib.org.apache.iceberg.common.DynMethods;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;

public class MetastoreUtil {
    private static final DynMethods.UnboundMethod ALTER_TABLE = DynMethods.builder("alter_table").impl(IMetaStoreClient.class, "alter_table_with_environmentContext", String.class, String.class, Table.class, EnvironmentContext.class).impl(IMetaStoreClient.class, "alter_table", String.class, String.class, Table.class, EnvironmentContext.class).impl(IMetaStoreClient.class, "alter_table", String.class, String.class, Table.class).build();

    private MetastoreUtil() {
    }

    public static void alterTable(IMetaStoreClient client, String databaseName, String tblName, Table table) throws TException {
        MetastoreUtil.alterTable(client, databaseName, tblName, table, ImmutableMap.of());
    }

    public static void alterTable(IMetaStoreClient client, String databaseName, String tblName, Table table, Map<String, String> extraEnv) throws TException {
        HashMap<String, String> env = Maps.newHashMapWithExpectedSize(extraEnv.size() + 1);
        env.putAll(extraEnv);
        env.put("DO_NOT_UPDATE_STATS", "true");
        try {
            ALTER_TABLE.invoke(client, databaseName, tblName, table, new EnvironmentContext(env));
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof TException) {
                throw (TException)e.getCause();
            }
            throw e;
        }
    }
}

