/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.inmemory;

import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.NotFoundException;
import com.dataiku.dss.shadelib.org.apache.iceberg.inmemory.InMemoryInputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.inmemory.InMemoryOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import java.util.Map;

public class InMemoryFileIO
implements FileIO {
    private static final Map<String, byte[]> IN_MEMORY_FILES = Maps.newConcurrentMap();
    private boolean closed = false;

    public void addFile(String location, byte[] contents) {
        Preconditions.checkState(!this.closed, "Cannot call addFile after calling close()");
        IN_MEMORY_FILES.put(location, contents);
    }

    public boolean fileExists(String location) {
        return IN_MEMORY_FILES.containsKey(location);
    }

    @Override
    public InputFile newInputFile(String location) {
        Preconditions.checkState(!this.closed, "Cannot call newInputFile after calling close()");
        byte[] contents = IN_MEMORY_FILES.get(location);
        if (null == contents) {
            throw new NotFoundException("No in-memory file found for location: %s", location);
        }
        return new InMemoryInputFile(location, contents);
    }

    @Override
    public OutputFile newOutputFile(String location) {
        Preconditions.checkState(!this.closed, "Cannot call newOutputFile after calling close()");
        return new InMemoryOutputFile(location, this);
    }

    @Override
    public void deleteFile(String location) {
        Preconditions.checkState(!this.closed, "Cannot call deleteFile after calling close()");
        if (null == IN_MEMORY_FILES.remove(location)) {
            throw new NotFoundException("No in-memory file found for location: %s", location);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

