/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.DeleteGranularity;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.PositionDelete;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.PositionDeleteIndex;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.SortingPositionOnlyDeleteWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DeleteWriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FanoutWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileWriterFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFileFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.RollingPositionDeleteWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.CharSequenceSet;
import java.util.List;
import java.util.function.Function;

public class FanoutPositionOnlyDeleteWriter<T>
extends FanoutWriter<PositionDelete<T>, DeleteWriteResult> {
    private final FileWriterFactory<T> writerFactory;
    private final OutputFileFactory fileFactory;
    private final FileIO io;
    private final long targetFileSizeInBytes;
    private final DeleteGranularity granularity;
    private final List<DeleteFile> deleteFiles;
    private final CharSequenceSet referencedDataFiles;
    private final List<DeleteFile> rewrittenDeleteFiles;
    private final Function<CharSequence, PositionDeleteIndex> loadPreviousDeletes;

    public FanoutPositionOnlyDeleteWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes) {
        this(writerFactory, fileFactory, io, targetFileSizeInBytes, DeleteGranularity.PARTITION);
    }

    public FanoutPositionOnlyDeleteWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes, DeleteGranularity granularity) {
        this(writerFactory, fileFactory, io, targetFileSizeInBytes, granularity, path -> null);
    }

    public FanoutPositionOnlyDeleteWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes, DeleteGranularity granularity, Function<CharSequence, PositionDeleteIndex> loadPreviousDeletes) {
        this.writerFactory = writerFactory;
        this.fileFactory = fileFactory;
        this.io = io;
        this.targetFileSizeInBytes = targetFileSizeInBytes;
        this.granularity = granularity;
        this.deleteFiles = Lists.newArrayList();
        this.referencedDataFiles = CharSequenceSet.empty();
        this.rewrittenDeleteFiles = Lists.newArrayList();
        this.loadPreviousDeletes = loadPreviousDeletes;
    }

    @Override
    protected FileWriter<PositionDelete<T>, DeleteWriteResult> newWriter(PartitionSpec spec, StructLike partition) {
        return new SortingPositionOnlyDeleteWriter(() -> new RollingPositionDeleteWriter<T>(this.writerFactory, this.fileFactory, this.io, this.targetFileSizeInBytes, spec, partition), this.granularity, this.loadPreviousDeletes);
    }

    @Override
    protected void addResult(DeleteWriteResult result) {
        this.deleteFiles.addAll(result.deleteFiles());
        this.referencedDataFiles.addAll(result.referencedDataFiles());
        this.rewrittenDeleteFiles.addAll(result.rewrittenDeleteFiles());
    }

    @Override
    protected DeleteWriteResult aggregatedResult() {
        return new DeleteWriteResult(this.deleteFiles, this.referencedDataFiles, this.rewrittenDeleteFiles);
    }
}

