/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.CatalogUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import java.io.IOException;
import java.util.Map;

public class FileIOParser {
    private static final String FILE_IO_IMPL = "io-impl";
    private static final String PROPERTIES = "properties";

    private FileIOParser() {
    }

    public static String toJson(FileIO io) {
        return FileIOParser.toJson(io, false);
    }

    public static String toJson(FileIO io, boolean pretty) {
        return JsonUtil.generate(gen -> FileIOParser.toJson(io, gen), pretty);
    }

    public static void toJson(FileIO io, JsonGenerator generator) throws IOException {
        Map<String, String> properties;
        String impl = io.getClass().getName();
        try {
            properties = io.properties();
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException(String.format("Cannot serialize FileIO: %s does not expose configuration properties", impl));
        }
        Preconditions.checkArgument(properties != null, "Cannot serialize FileIO: invalid configuration properties (null)", (Object)impl);
        generator.writeStartObject();
        generator.writeStringField(FILE_IO_IMPL, impl);
        JsonUtil.writeStringMap(PROPERTIES, properties, generator);
        generator.writeEndObject();
    }

    public static FileIO fromJson(String json) {
        return FileIOParser.fromJson(json, null);
    }

    public static FileIO fromJson(String json, Object conf) {
        return JsonUtil.parse(json, node -> FileIOParser.fromJson(node, conf));
    }

    public static FileIO fromJson(JsonNode json, Object conf) {
        Preconditions.checkArgument(json.isObject(), "Cannot parse FileIO from non-object: %s", (Object)json);
        String impl = JsonUtil.getString(FILE_IO_IMPL, json);
        Map<String, String> properties = JsonUtil.getStringMap(PROPERTIES, json);
        return CatalogUtil.loadFileIO(impl, properties, conf);
    }
}

