/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.TableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Closeable;

public class FileIOTracker
implements Closeable {
    private final Cache<TableOperations, FileIO> tracker = Caffeine.newBuilder().weakKeys().removalListener((ops, fileIO, cause) -> {
        if (null != fileIO) {
            fileIO.close();
        }
    }).build();

    public void track(TableOperations ops) {
        Preconditions.checkArgument(null != ops, "Invalid table ops: null");
        this.tracker.put((Object)ops, (Object)ops.io());
    }

    @VisibleForTesting
    Cache<TableOperations, FileIO> tracker() {
        return this.tracker;
    }

    @Override
    public void close() {
        this.tracker.invalidateAll();
        this.tracker.cleanUp();
    }
}

