/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class FilterIterator<T>
implements CloseableIterator<T> {
    private final Iterator<T> items;
    private boolean closed;
    private boolean nextReady;
    private T next;

    protected FilterIterator(Iterator<T> items) {
        this.items = items;
        this.closed = false;
        this.next = null;
        this.nextReady = false;
    }

    protected abstract boolean shouldKeep(T var1);

    @Override
    public boolean hasNext() {
        return this.nextReady || this.advance();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextReady = false;
        return this.next;
    }

    private boolean advance() {
        while (!this.closed && this.items.hasNext()) {
            this.next = this.items.next();
            if (!this.shouldKeep(this.next)) continue;
            this.nextReady = true;
            return true;
        }
        this.close();
        this.nextReady = false;
        return false;
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                ((Closeable)((Object)this.items)).close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.closed = true;
        }
    }
}

