/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.FileFormat;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionKey;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.BaseTaskWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileAppenderFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFileFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PartitionedWriter<T>
extends BaseTaskWriter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionedWriter.class);
    private final Set<PartitionKey> completedPartitions = Sets.newHashSet();
    private PartitionKey currentKey = null;
    private BaseTaskWriter.RollingFileWriter currentWriter = null;

    protected PartitionedWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<T> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize) {
        super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
    }

    protected abstract PartitionKey partition(T var1);

    @Override
    public void write(T row) throws IOException {
        PartitionKey key = this.partition(row);
        if (!key.equals(this.currentKey)) {
            if (this.currentKey != null) {
                this.currentWriter.close();
                this.completedPartitions.add(this.currentKey);
            }
            if (this.completedPartitions.contains(key)) {
                PartitionKey existingKey = Iterables.find(this.completedPartitions, x$0 -> key.equals(x$0), null);
                LOG.warn("Duplicate key: {} == {}", (Object)existingKey, (Object)key);
                throw new IllegalStateException("Already closed files for partition: " + key.toPath());
            }
            this.currentKey = key.copy();
            this.currentWriter = new BaseTaskWriter.RollingFileWriter(this.currentKey);
        }
        this.currentWriter.write(row);
    }

    @Override
    public void close() throws IOException {
        if (this.currentWriter != null) {
            this.currentWriter.close();
        }
    }
}

