/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.PositionDelete;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.PositionDeleteWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DeleteWriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileWriterFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFileFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.RollingFileWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.CharSequenceSet;
import java.util.List;

public class RollingPositionDeleteWriter<T>
extends RollingFileWriter<PositionDelete<T>, PositionDeleteWriter<T>, DeleteWriteResult> {
    private final FileWriterFactory<T> writerFactory;
    private final List<DeleteFile> deleteFiles;
    private final CharSequenceSet referencedDataFiles;

    public RollingPositionDeleteWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes, PartitionSpec spec, StructLike partition) {
        super(fileFactory, io, targetFileSizeInBytes, spec, partition);
        this.writerFactory = writerFactory;
        this.deleteFiles = Lists.newArrayList();
        this.referencedDataFiles = CharSequenceSet.empty();
        this.openCurrentWriter();
    }

    @Override
    protected PositionDeleteWriter<T> newWriter(EncryptedOutputFile file) {
        return this.writerFactory.newPositionDeleteWriter(file, this.spec(), this.partition());
    }

    @Override
    protected void addResult(DeleteWriteResult result) {
        this.deleteFiles.addAll(result.deleteFiles());
        this.referencedDataFiles.addAll(result.referencedDataFiles());
    }

    @Override
    protected DeleteWriteResult aggregatedResult() {
        return new DeleteWriteResult(this.deleteFiles, this.referencedDataFiles);
    }
}

