/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.mapping;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.mapping.MappedField;
import com.dataiku.dss.shadelib.org.apache.iceberg.mapping.MappedFields;
import com.dataiku.dss.shadelib.org.apache.iceberg.mapping.NameMapping;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;

public class NameMappingParser {
    private static final String FIELD_ID = "field-id";
    private static final String NAMES = "names";
    private static final String FIELDS = "fields";

    private NameMappingParser() {
    }

    public static String toJson(NameMapping mapping) {
        return JsonUtil.generate(gen -> NameMappingParser.toJson(mapping, gen), true);
    }

    static void toJson(NameMapping nameMapping, JsonGenerator generator) throws IOException {
        NameMappingParser.toJson(nameMapping.asMappedFields(), generator);
    }

    private static void toJson(MappedFields mapping, JsonGenerator generator) throws IOException {
        generator.writeStartArray();
        for (MappedField field : mapping.fields()) {
            NameMappingParser.toJson(field, generator);
        }
        generator.writeEndArray();
    }

    private static void toJson(MappedField field, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField(FIELD_ID, field.id());
        JsonUtil.writeStringArray(NAMES, field.names(), generator);
        MappedFields nested = field.nestedMapping();
        if (nested != null) {
            generator.writeFieldName(FIELDS);
            NameMappingParser.toJson(nested, generator);
        }
        generator.writeEndObject();
    }

    public static NameMapping fromJson(String json) {
        return JsonUtil.parse(json, NameMappingParser::fromJson);
    }

    static NameMapping fromJson(JsonNode node) {
        return new NameMapping(NameMappingParser.fieldsFromJson(node));
    }

    private static MappedFields fieldsFromJson(JsonNode node) {
        Preconditions.checkArgument(node.isArray(), "Cannot parse non-array mapping fields: %s", (Object)node);
        ArrayList<MappedField> fields = Lists.newArrayList();
        node.elements().forEachRemaining(fieldNode -> fields.add(NameMappingParser.fieldFromJson(fieldNode)));
        return MappedFields.of(fields);
    }

    private static MappedField fieldFromJson(JsonNode node) {
        Preconditions.checkArgument(node != null && !node.isNull() && node.isObject(), "Cannot parse non-object mapping field: %s", (Object)node);
        Integer id = JsonUtil.getIntOrNull(FIELD_ID, node);
        ImmutableSet<String> names = node.has(NAMES) ? ImmutableSet.copyOf(JsonUtil.getStringList(NAMES, node)) : ImmutableSet.of();
        MappedFields nested = node.has(FIELDS) ? NameMappingParser.fieldsFromJson(node.get(FIELDS)) : null;
        return MappedField.of(id, names, nested);
    }
}

