/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.nessie;

import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.AlreadyExistsException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.CommitFailedException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.CommitStateUnknownException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.NoSuchNamespaceException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.NoSuchTableException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.NoSuchViewException;
import com.dataiku.dss.shadelib.org.apache.iceberg.nessie.NessieUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.nessie.UpdateableReference;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Suppliers;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.Tasks;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewMetadata;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetContentBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetEntriesBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.NessieApiV1;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.OnReferenceBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpClientException;
import com.dataiku.dss.shadelib.org.projectnessie.error.BaseNessieClientServerException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieConflictException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieContentNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieReferenceConflictException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieReferenceNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.model.Branch;
import com.dataiku.dss.shadelib.org.projectnessie.model.CommitMeta;
import com.dataiku.dss.shadelib.org.projectnessie.model.Conflict;
import com.dataiku.dss.shadelib.org.projectnessie.model.Content;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentKey;
import com.dataiku.dss.shadelib.org.projectnessie.model.EntriesResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.IcebergContent;
import com.dataiku.dss.shadelib.org.projectnessie.model.IcebergTable;
import com.dataiku.dss.shadelib.org.projectnessie.model.IcebergView;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableCommitMeta;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableIcebergTable;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableIcebergView;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableNamespace;
import com.dataiku.dss.shadelib.org.projectnessie.model.Namespace;
import com.dataiku.dss.shadelib.org.projectnessie.model.Operation;
import com.dataiku.dss.shadelib.org.projectnessie.model.Reference;
import com.dataiku.dss.shadelib.org.projectnessie.model.Tag;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieIcebergClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NessieIcebergClient.class);
    private final NessieApiV1 api;
    private final Supplier<UpdateableReference> reference;
    private final Map<String, String> catalogOptions;

    public NessieIcebergClient(NessieApiV1 api, String requestedRef, String requestedHash, Map<String, String> catalogOptions) {
        this.api = api;
        this.catalogOptions = catalogOptions;
        this.reference = Suppliers.memoize(() -> this.loadReference(requestedRef, requestedHash));
    }

    public NessieApiV1 getApi() {
        return this.api;
    }

    UpdateableReference getRef() {
        return this.reference.get();
    }

    public Reference getReference() {
        return this.reference.get().getReference();
    }

    public void refresh() throws NessieNotFoundException {
        this.getRef().refresh(this.api);
    }

    public NessieIcebergClient withReference(String requestedRef, String hash) {
        if (null == requestedRef || this.getRef().getReference().getName().equals(requestedRef) && this.getRef().getHash().equals(hash)) {
            return this;
        }
        return new NessieIcebergClient(this.getApi(), requestedRef, hash, this.catalogOptions);
    }

    private UpdateableReference loadReference(String requestedRef, String hash) {
        try {
            Reference ref;
            Reference reference = ref = requestedRef == null ? this.api.getDefaultBranch() : this.api.getReference().refName(requestedRef).get();
            if (hash != null) {
                ref = ref instanceof Branch ? Branch.of(ref.getName(), hash) : Tag.of(ref.getName(), hash);
            }
            return new UpdateableReference(ref, hash != null);
        }
        catch (NessieNotFoundException ex) {
            if (requestedRef != null) {
                throw new IllegalArgumentException(String.format("Nessie ref '%s' does not exist", requestedRef), ex);
            }
            throw new IllegalArgumentException(String.format("Nessie does not have an existing default branch. Either configure an alternative ref via '%s' or create the default branch on the server.", "nessie.ref"), ex);
        }
    }

    public List<TableIdentifier> listTables(com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace namespace) {
        return this.listContents(namespace, Content.Type.ICEBERG_TABLE);
    }

    public List<TableIdentifier> listViews(com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace namespace) {
        return this.listContents(namespace, Content.Type.ICEBERG_VIEW);
    }

    private List<TableIdentifier> listContents(com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace namespace, Content.Type type) {
        try {
            return this.withReference(this.api.getEntries()).get().getEntries().stream().filter(this.namespacePredicate(namespace)).filter(e -> type.equals(e.getType())).map(this::toIdentifier).collect(Collectors.toList());
        }
        catch (NessieNotFoundException ex) {
            throw new NoSuchNamespaceException(ex, "Unable to list %ss due to missing ref '%s'", NessieUtil.contentTypeString(type).toLowerCase(Locale.ENGLISH), this.getRef().getName());
        }
    }

    private Predicate<EntriesResponse.Entry> namespacePredicate(com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace ns) {
        if (ns == null) {
            return e -> true;
        }
        List<String> namespace = Arrays.asList(ns.levels());
        return e -> {
            List<String> names = e.getName().getElements();
            if (names.size() <= namespace.size()) {
                return false;
            }
            return namespace.equals(names.subList(0, namespace.size()));
        };
    }

    private TableIdentifier toIdentifier(EntriesResponse.Entry entry) {
        List<String> elements = entry.getName().getElements();
        return TableIdentifier.of(elements.toArray(new String[0]));
    }

    public IcebergTable table(TableIdentifier tableIdentifier) {
        IcebergContent icebergContent = this.fetchContent(tableIdentifier);
        return icebergContent == null ? null : (IcebergTable)icebergContent.unwrap(IcebergTable.class).orElse(null);
    }

    public IcebergView view(TableIdentifier tableIdentifier) {
        IcebergContent icebergContent = this.fetchContent(tableIdentifier);
        return icebergContent == null ? null : (IcebergView)icebergContent.unwrap(IcebergView.class).orElse(null);
    }

    public IcebergContent fetchContent(TableIdentifier tableIdentifier) {
        try {
            ContentKey key = NessieUtil.toKey(tableIdentifier);
            Content content = this.withReference(this.api.getContent().key(key)).get().get(key);
            return content != null ? (IcebergContent)content.unwrap(IcebergContent.class).orElse(null) : null;
        }
        catch (NessieNotFoundException e) {
            return null;
        }
    }

    public void createNamespace(com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace namespace, Map<String, String> metadata) {
        NessieIcebergClient.checkNamespaceIsValid(namespace);
        this.getRef().checkMutable();
        ContentKey key = ContentKey.of(namespace.levels());
        Namespace content = Namespace.of(key.getElements(), metadata);
        try {
            Content existing = ((GetContentBuilder)this.api.getContent().reference(this.getReference())).key(key).get().get(key);
            if (existing != null) {
                throw NessieIcebergClient.namespaceAlreadyExists(key, existing, null);
            }
            try {
                this.commitRetry("create namespace " + String.valueOf(key), Operation.Put.of(key, content));
            }
            catch (NessieReferenceConflictException e) {
                Optional<Conflict> conflict = NessieUtil.extractSingleConflict(e, EnumSet.of(Conflict.ConflictType.KEY_EXISTS, Conflict.ConflictType.NAMESPACE_ABSENT));
                if (conflict.isPresent()) {
                    switch (conflict.get().conflictType()) {
                        case KEY_EXISTS: {
                            Content conflicting = this.withReference(this.api.getContent()).key(key).get().get(key);
                            throw NessieIcebergClient.namespaceAlreadyExists(key, conflicting, e);
                        }
                        case NAMESPACE_ABSENT: {
                            throw new NoSuchNamespaceException(e, "Cannot create namespace '%s': parent namespace '%s' does not exist", namespace, conflict.get().key());
                        }
                    }
                }
                throw new RuntimeException(String.format("Cannot create namespace '%s': %s", namespace, e.getMessage()));
            }
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException(String.format("Cannot create namespace '%s': ref '%s' is no longer valid.", namespace, this.getRef().getName()), e);
        }
        catch (BaseNessieClientServerException e) {
            throw new RuntimeException(String.format("Cannot create namespace '%s': %s", namespace, e.getMessage()), e);
        }
    }

    public List<com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace> listNamespaces(com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace namespace) throws NoSuchNamespaceException {
        try {
            Object filter = "entry.contentType == 'NAMESPACE' && ";
            if (namespace.isEmpty()) {
                filter = (String)filter + "size(entry.keyElements) == 1";
            } else {
                Namespace root = Namespace.of(namespace.levels());
                Content existing = ((GetContentBuilder)this.api.getContent().reference(this.getReference())).key(root.toContentKey()).get().get(root.toContentKey());
                if (existing == null) {
                    throw new NoSuchNamespaceException("Namespace does not exist: %s", namespace);
                }
                filter = (String)filter + String.format(Locale.ROOT, "size(entry.keyElements) == %d && entry.encodedKey.startsWith('%s.')", root.getElementCount() + 1, root.name());
            }
            List<ContentKey> entries = ((GetEntriesBuilder)this.withReference(this.api.getEntries()).filter((String)filter)).stream().map(EntriesResponse.Entry::getName).collect(Collectors.toList());
            if (entries.isEmpty()) {
                return Collections.emptyList();
            }
            GetContentBuilder getContent = this.withReference(this.api.getContent());
            entries.forEach(getContent::key);
            return getContent.get().values().stream().map(v -> v.unwrap(Namespace.class)).filter(Optional::isPresent).map(Optional::get).map(v -> com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace.of(v.getElements().toArray(new String[0]))).collect(Collectors.toList());
        }
        catch (NessieNotFoundException e) {
            if (namespace.isEmpty()) {
                throw new NoSuchNamespaceException(e, "Cannot list top-level namespaces: ref '%s' is no longer valid.", this.getRef().getName());
            }
            throw new NoSuchNamespaceException(e, "Cannot list child namespaces from '%s': ref '%s' is no longer valid.", namespace, this.getRef().getName());
        }
    }

    public boolean dropNamespace(com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace namespace) throws NamespaceNotEmptyException {
        NessieIcebergClient.checkNamespaceIsValid(namespace);
        this.getRef().checkMutable();
        ContentKey key = ContentKey.of(namespace.levels());
        try {
            Map<ContentKey, Content> contentMap = ((GetContentBuilder)this.api.getContent().reference(this.getReference())).key(key).get();
            Content existing = contentMap.get(key);
            if (existing != null && !existing.getType().equals(Content.Type.NAMESPACE)) {
                throw new NoSuchNamespaceException("Content object with name '%s' is not a namespace.", namespace);
            }
            try {
                this.commitRetry("drop namespace " + String.valueOf(key), Operation.Delete.of(key));
                return true;
            }
            catch (NessieReferenceConflictException e) {
                Optional<Conflict> conflict = NessieUtil.extractSingleConflict(e, EnumSet.of(Conflict.ConflictType.KEY_DOES_NOT_EXIST, Conflict.ConflictType.NAMESPACE_NOT_EMPTY));
                if (conflict.isPresent()) {
                    Conflict.ConflictType conflictType = conflict.get().conflictType();
                    switch (conflictType) {
                        case KEY_DOES_NOT_EXIST: {
                            return false;
                        }
                        case NAMESPACE_NOT_EMPTY: {
                            throw new NamespaceNotEmptyException(e, "Namespace '%s' is not empty.", namespace);
                        }
                    }
                }
                throw new RuntimeException(String.format("Cannot drop namespace '%s': %s", namespace, e.getMessage()));
            }
        }
        catch (NessieNotFoundException e) {
            LOG.error("Cannot drop namespace '{}': ref '{}' is no longer valid.", new Object[]{namespace, this.getRef().getName(), e});
        }
        catch (BaseNessieClientServerException e) {
            throw new RuntimeException(String.format("Cannot drop namespace '%s': %s", namespace, e.getMessage()), e);
        }
        return false;
    }

    private static void checkNamespaceIsValid(com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace namespace) {
        if (namespace.isEmpty()) {
            throw new NoSuchNamespaceException("Invalid namespace: %s", namespace);
        }
    }

    public Map<String, String> loadNamespaceMetadata(com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace namespace) throws NoSuchNamespaceException {
        NessieIcebergClient.checkNamespaceIsValid(namespace);
        ContentKey key = ContentKey.of(namespace.levels());
        try {
            Map<ContentKey, Content> contentMap = this.withReference(this.api.getContent()).key(key).get();
            return NessieIcebergClient.unwrapNamespace(contentMap.get(key)).orElseThrow(() -> new NoSuchNamespaceException("Namespace does not exist: %s", namespace)).getProperties();
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException(String.format("Cannot load namespace '%s': ref '%s' is no longer valid.", namespace, this.getRef().getName()), e);
        }
    }

    public boolean setProperties(com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace namespace, Map<String, String> properties) {
        return this.updateProperties(namespace, props -> props.putAll(properties));
    }

    public boolean removeProperties(com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace namespace, Set<String> properties) {
        return this.updateProperties(namespace, props -> props.keySet().removeAll(properties));
    }

    private boolean updateProperties(com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace namespace, Consumer<Map<String, String>> action) {
        NessieIcebergClient.checkNamespaceIsValid(namespace);
        this.getRef().checkMutable();
        ContentKey key = ContentKey.of(namespace.levels());
        try {
            this.commitRetry("update namespace " + String.valueOf(key), true, (CommitMultipleOperationsBuilder commitBuilder) -> {
                Namespace oldNamespace = NessieIcebergClient.unwrapNamespace(((GetContentBuilder)this.api.getContent().reference(this.getReference())).key(key).get().get(key)).orElseThrow(() -> new NessieContentNotFoundException(key, this.getReference().getName()));
                HashMap<String, String> newProperties = Maps.newHashMap(oldNamespace.getProperties());
                action.accept(newProperties);
                ImmutableNamespace updatedNamespace = Namespace.builder().from(oldNamespace).properties(newProperties).build();
                commitBuilder.operation(Operation.Put.of(key, updatedNamespace));
                return commitBuilder;
            });
            return true;
        }
        catch (NessieReferenceConflictException e) {
            Optional<Conflict> conflict = NessieUtil.extractSingleConflict(e, EnumSet.of(Conflict.ConflictType.KEY_DOES_NOT_EXIST));
            if (conflict.isPresent() && conflict.get().conflictType() == Conflict.ConflictType.KEY_DOES_NOT_EXIST) {
                throw new NoSuchNamespaceException(e, "Namespace does not exist: %s", namespace);
            }
            throw new RuntimeException(String.format("Cannot update properties on namespace '%s': %s", namespace, e.getMessage()));
        }
        catch (NessieContentNotFoundException e) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", namespace);
        }
        catch (NessieReferenceNotFoundException e) {
            throw new RuntimeException(String.format("Cannot update properties on namespace '%s': ref '%s' is no longer valid.", namespace, this.getRef().getName()), e);
        }
        catch (BaseNessieClientServerException e) {
            throw new RuntimeException(String.format("Cannot update namespace '%s': %s", namespace, e.getMessage()), e);
        }
    }

    public void renameTable(TableIdentifier from, TableIdentifier to) {
        this.renameContent(from, to, Content.Type.ICEBERG_TABLE);
    }

    public void renameView(TableIdentifier from, TableIdentifier to) {
        this.renameContent(from, to, Content.Type.ICEBERG_VIEW);
    }

    private void renameContent(TableIdentifier from, TableIdentifier to, Content.Type type) {
        this.getRef().checkMutable();
        IcebergContent existingFromContent = this.fetchContent(from);
        NessieIcebergClient.validateFromContentForRename(from, type, existingFromContent);
        IcebergContent existingToContent = this.fetchContent(to);
        NessieIcebergClient.validateToContentForRename(from, to, existingToContent);
        String contentType = NessieUtil.contentTypeString(type).toLowerCase(Locale.ENGLISH);
        try {
            this.commitRetry(String.format("Iceberg rename %s from '%s' to '%s'", contentType, from, to), Operation.Delete.of(NessieUtil.toKey(from)), Operation.Put.of(NessieUtil.toKey(to), existingFromContent));
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException(String.format("Cannot rename %s '%s' to '%s': ref '%s' no longer exists.", contentType, from, to, this.getRef().getName()), e);
        }
        catch (BaseNessieClientServerException e) {
            CommitFailedException commitFailedException = new CommitFailedException(e, "Cannot rename %s '%s' to '%s': the current reference is not up to date.", contentType, from, to);
            Optional<RuntimeException> exception = Optional.empty();
            if (e instanceof NessieConflictException) {
                exception = NessieUtil.handleExceptionsForCommits(e, this.getRef().getName(), type);
            }
            throw (RuntimeException)exception.orElse(commitFailedException);
        }
        catch (HttpClientException ex) {
            throw new CommitStateUnknownException(ex);
        }
    }

    private static void validateToContentForRename(TableIdentifier from, TableIdentifier to, IcebergContent existingToContent) {
        if (existingToContent != null) {
            if (existingToContent.getType() == Content.Type.ICEBERG_VIEW) {
                throw new AlreadyExistsException("Cannot rename %s to %s. View already exists", from, to);
            }
            if (existingToContent.getType() == Content.Type.ICEBERG_TABLE) {
                throw new AlreadyExistsException("Cannot rename %s to %s. Table already exists", from, to);
            }
            throw new AlreadyExistsException("Cannot rename %s to %s. Another content of type %s with same name already exists", from, to, existingToContent.getType());
        }
    }

    private static void validateFromContentForRename(TableIdentifier from, Content.Type type, IcebergContent existingFromContent) {
        if (existingFromContent == null) {
            if (type == Content.Type.ICEBERG_VIEW) {
                throw new NoSuchViewException("View does not exist: %s", from);
            }
            if (type == Content.Type.ICEBERG_TABLE) {
                throw new NoSuchTableException("Table does not exist: %s", from);
            }
            throw new RuntimeException("Cannot perform rename for content type: " + String.valueOf(type));
        }
        if (existingFromContent.getType() != type) {
            throw new RuntimeException(String.format("content type of from identifier %s should be of %s", from, type));
        }
    }

    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        return this.dropContent(identifier, purge, Content.Type.ICEBERG_TABLE);
    }

    public boolean dropView(TableIdentifier identifier, boolean purge) {
        return this.dropContent(identifier, purge, Content.Type.ICEBERG_VIEW);
    }

    private boolean dropContent(TableIdentifier identifier, boolean purge, Content.Type type) {
        this.getRef().checkMutable();
        IcebergContent existingContent = this.fetchContent(identifier);
        if (existingContent == null) {
            return false;
        }
        if (existingContent.getType() != type) {
            throw new RuntimeException(String.format("Cannot drop %s: not matching with the type `%s`", identifier, NessieUtil.contentTypeString(type)));
        }
        String contentType = NessieUtil.contentTypeString(type).toLowerCase(Locale.ENGLISH);
        if (purge) {
            LOG.info("Purging data for {} {} was set to true but is ignored", (Object)contentType, (Object)identifier.toString());
        }
        try {
            this.commitRetry(String.format("Iceberg delete %s %s", contentType, identifier), Operation.Delete.of(NessieUtil.toKey(identifier)));
            return true;
        }
        catch (NessieConflictException e) {
            LOG.error("Cannot drop {}: failed after retry (update ref '{}' and retry)", new Object[]{contentType, this.getRef().getName(), e});
        }
        catch (NessieNotFoundException e) {
            LOG.error("Cannot drop {}: ref '{}' is no longer valid.", new Object[]{contentType, this.getRef().getName(), e});
        }
        catch (BaseNessieClientServerException e) {
            LOG.error("Cannot drop {}: unknown error", (Object)contentType, (Object)e);
        }
        return false;
    }

    public void commitTable(TableMetadata base, TableMetadata metadata, String newMetadataLocation, String contentId, ContentKey key) throws NessieConflictException, NessieNotFoundException {
        Snapshot snapshot = metadata.currentSnapshot();
        long snapshotId = snapshot != null ? snapshot.snapshotId() : -1L;
        ImmutableCommitMeta.Builder builder = ImmutableCommitMeta.builder();
        builder.message(this.buildCommitMsg(base, metadata, key.toString()));
        if (this.isSnapshotOperation(base, metadata)) {
            builder.putProperties("iceberg.operation", snapshot.operation());
        }
        ImmutableCommitMeta commitMeta = NessieUtil.catalogOptions(builder, this.catalogOptions).build();
        ImmutableIcebergTable.Builder newTableBuilder = ImmutableIcebergTable.builder();
        ImmutableIcebergTable newTable = newTableBuilder.id(contentId).snapshotId(snapshotId).schemaId(metadata.currentSchemaId()).specId(metadata.defaultSpecId()).sortOrderId(metadata.defaultSortOrderId()).metadataLocation(newMetadataLocation).build();
        Map<String, String> properties = base != null ? base.properties() : null;
        this.commitContent(key, newTable, properties, commitMeta);
    }

    public void commitView(ViewMetadata base, ViewMetadata metadata, String newMetadataLocation, String contentId, ContentKey key) throws NessieConflictException, NessieNotFoundException {
        long versionId = metadata.currentVersion().versionId();
        ImmutableIcebergView.Builder newViewBuilder = ImmutableIcebergView.builder();
        ImmutableIcebergView newView = newViewBuilder.id(contentId).versionId(versionId).schemaId(metadata.currentSchemaId()).metadataLocation(newMetadataLocation).sqlText("-").dialect("-").build();
        ImmutableCommitMeta.Builder builder = ImmutableCommitMeta.builder();
        builder.message(this.buildCommitMsg(base, metadata, key.toString()));
        builder.putProperties("iceberg.operation", metadata.currentVersion().operation());
        ImmutableCommitMeta commitMeta = NessieUtil.catalogOptions(builder, this.catalogOptions).build();
        Map<String, String> properties = base != null ? base.properties() : null;
        this.commitContent(key, newView, properties, commitMeta);
    }

    private void commitContent(ContentKey key, IcebergContent newContent, Map<String, String> properties, CommitMeta commitMeta) throws NessieNotFoundException, NessieConflictException {
        String metadataCommitId;
        Branch current;
        UpdateableReference updateableReference = this.getRef();
        updateableReference.checkMutable();
        Branch expectedHead = current = (Branch)updateableReference.getReference();
        if (properties != null && (metadataCommitId = properties.getOrDefault("nessie.commit.id", expectedHead.getHash())) != null) {
            expectedHead = Branch.of(expectedHead.getName(), metadataCommitId);
        }
        LOG.debug("Committing '{}' against '{}', current is '{}': {}", new Object[]{key, expectedHead, current.getHash(), newContent});
        Branch branch = ((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().operation(Operation.Put.of(key, newContent)).commitMeta(commitMeta).branch(expectedHead)).commit();
        LOG.info("Committed '{}' against '{}', expected commit-id was '{}'", new Object[]{key, branch, expectedHead.getHash()});
        updateableReference.updateReference(branch);
    }

    private boolean isSnapshotOperation(TableMetadata base, TableMetadata metadata) {
        Snapshot snapshot = metadata.currentSnapshot();
        return snapshot != null && (base == null || base.currentSnapshot() == null || snapshot.snapshotId() != base.currentSnapshot().snapshotId());
    }

    private <T extends OnReferenceBuilder<?>> T withReference(T builder) {
        UpdateableReference ref = this.getRef();
        if (!ref.isMutable()) {
            builder.reference(ref.getReference());
        } else {
            builder.refName(ref.getName());
        }
        return builder;
    }

    private String buildCommitMsg(TableMetadata base, TableMetadata metadata, String tableName) {
        if (this.isSnapshotOperation(base, metadata)) {
            return String.format("Iceberg %s against %s", metadata.currentSnapshot().operation(), tableName);
        }
        if (base != null && metadata.currentSchemaId() != base.currentSchemaId()) {
            return String.format("Iceberg schema change against table %s", tableName);
        }
        if (base == null) {
            return String.format("Iceberg table created/registered with name %s", tableName);
        }
        return String.format("Iceberg commit against table %s", tableName);
    }

    private String buildCommitMsg(ViewMetadata base, ViewMetadata metadata, String viewName) {
        String operation = metadata.currentVersion().operation();
        if (base != null && !metadata.currentSchemaId().equals(base.currentSchemaId())) {
            return String.format("Iceberg schema change against view %s for the operation %s", viewName, operation);
        }
        return String.format("Iceberg view %sd with name %s", operation, viewName);
    }

    public String refName() {
        return this.getRef().getName();
    }

    @Override
    public void close() {
        if (null != this.api) {
            this.api.close();
        }
    }

    private void commitRetry(String message, Operation ... ops) throws BaseNessieClientServerException {
        this.commitRetry(message, false, (CommitMultipleOperationsBuilder builder) -> builder.operations(Arrays.asList(ops)));
    }

    private void commitRetry(String message, boolean retryConflicts, CommitEnhancer commitEnhancer) throws BaseNessieClientServerException {
        Predicate<Exception> shouldRetry = e -> !(e instanceof NessieNotFoundException) && (!(e instanceof NessieConflictException) || retryConflicts);
        Tasks.range(1).retry(5).shouldRetryTest(shouldRetry).throwFailureWhenFinished().onFailure((o, exception) -> this.refresh()).run(i -> {
            try {
                Branch branch = ((CommitMultipleOperationsBuilder)commitEnhancer.enhance(this.api.commitMultipleOperations()).commitMeta(NessieUtil.buildCommitMetadata(message, this.catalogOptions)).branch((Branch)this.getReference())).commit();
                this.getRef().updateReference(branch);
            }
            catch (NessieConflictException e) {
                if (retryConflicts) {
                    this.refresh();
                }
                throw e;
            }
        }, BaseNessieClientServerException.class);
    }

    private static AlreadyExistsException namespaceAlreadyExists(ContentKey key, @Nullable Content existing, @Nullable Exception ex) {
        if (existing instanceof Namespace) {
            return new AlreadyExistsException(ex, "Namespace already exists: %s", key);
        }
        return new AlreadyExistsException(ex, "Another content object with name '%s' already exists", key);
    }

    private static Optional<Namespace> unwrapNamespace(Content content) {
        return content == null ? Optional.empty() : content.unwrap(Namespace.class);
    }

    private static interface CommitEnhancer {
        public CommitMultipleOperationsBuilder enhance(CommitMultipleOperationsBuilder var1) throws BaseNessieClientServerException;
    }
}

