/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.nessie;

import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.NoSuchViewException;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.nessie.NessieIcebergClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.nessie.NessieUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.BaseViewOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewMetadataParser;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetContentBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpClientException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieBadRequestException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieConflictException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieContentNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.model.Content;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentKey;
import com.dataiku.dss.shadelib.org.projectnessie.model.IcebergView;
import com.dataiku.dss.shadelib.org.projectnessie.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieViewOperations
extends BaseViewOperations {
    private static final Logger LOG = LoggerFactory.getLogger(NessieViewOperations.class);
    private final NessieIcebergClient client;
    private final ContentKey key;
    private final FileIO fileIO;
    private IcebergView icebergView;

    NessieViewOperations(ContentKey key, NessieIcebergClient client, FileIO fileIO) {
        this.key = key;
        this.client = client;
        this.fileIO = fileIO;
    }

    @Override
    public void doRefresh() {
        Reference reference;
        String metadataLocation;
        block7: {
            try {
                this.client.refresh();
            }
            catch (NessieNotFoundException e) {
                throw new RuntimeException(String.format("Failed to refresh as ref '%s' is no longer valid.", this.client.getRef().getName()), e);
            }
            metadataLocation = null;
            reference = this.client.getRef().getReference();
            try {
                Content content = ((GetContentBuilder)this.client.getApi().getContent().key(this.key).reference(reference)).get().get(this.key);
                LOG.debug("Content '{}' at '{}': {}", new Object[]{this.key, reference, content});
                if (content == null) {
                    if (this.currentMetadataLocation() != null) {
                        throw new NoSuchViewException("View does not exist: %s in %s", this.key, reference);
                    }
                } else {
                    this.icebergView = content.unwrap(IcebergView.class).orElseThrow(() -> new NessieContentNotFoundException(this.key, reference.getName()));
                    metadataLocation = this.icebergView.getMetadataLocation();
                }
            }
            catch (NessieNotFoundException ex) {
                if (this.currentMetadataLocation() == null) break block7;
                throw new NoSuchViewException("View does not exist: %s in %s", this.key, reference);
            }
        }
        this.refreshFromMetadataLocation(metadataLocation, null, 2, location -> NessieUtil.loadViewMetadata(ViewMetadataParser.read(this.io().newInputFile((String)location)), location, reference));
    }

    @Override
    public void doCommit(ViewMetadata base, ViewMetadata metadata) {
        String newMetadataLocation = this.writeNewMetadataIfRequired(metadata);
        boolean failure = false;
        try {
            String contentId = this.icebergView == null ? null : this.icebergView.getId();
            this.client.commitView(base, metadata, newMetadataLocation, contentId, this.key);
        }
        catch (HttpClientException | NessieConflictException | NessieNotFoundException ex) {
            if (ex instanceof NessieConflictException || ex instanceof NessieNotFoundException) {
                failure = true;
            }
            NessieUtil.handleExceptionsForCommits(ex, this.client.refName(), Content.Type.ICEBERG_VIEW).ifPresent(exception -> {
                throw exception;
            });
        }
        catch (NessieBadRequestException ex) {
            failure = true;
            throw NessieUtil.handleBadRequestForCommit(this.client, this.key, Content.Type.ICEBERG_VIEW).orElse(ex);
        }
        finally {
            if (failure) {
                this.io().deleteFile(newMetadataLocation);
            }
        }
    }

    @Override
    protected String viewName() {
        return this.key.toString();
    }

    @Override
    public FileIO io() {
        return this.fileIO;
    }
}

