/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.parquet;

import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.BasePageIterator;
import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.ParquetUtil;
import com.dataiku.dss.shadelib.org.apache.parquet.column.ColumnDescriptor;
import com.dataiku.dss.shadelib.org.apache.parquet.column.Dictionary;
import com.dataiku.dss.shadelib.org.apache.parquet.column.page.DataPage;
import com.dataiku.dss.shadelib.org.apache.parquet.column.page.PageReader;

public abstract class BaseColumnIterator {
    protected final ColumnDescriptor desc;
    protected PageReader pageSource = null;
    protected long triplesCount = 0L;
    protected long triplesRead = 0L;
    protected long advanceNextPageCount = 0L;
    protected Dictionary dictionary;

    protected BaseColumnIterator(ColumnDescriptor descriptor) {
        this.desc = descriptor;
    }

    public void setPageSource(PageReader source) {
        this.pageSource = source;
        this.triplesCount = source.getTotalValueCount();
        this.triplesRead = 0L;
        this.advanceNextPageCount = 0L;
        BasePageIterator pageIterator = this.pageIterator();
        pageIterator.reset();
        this.dictionary = ParquetUtil.readDictionary(this.desc, this.pageSource);
        pageIterator.setDictionary(this.dictionary);
        this.advance();
    }

    protected abstract BasePageIterator pageIterator();

    protected void advance() {
        if (this.triplesRead >= this.advanceNextPageCount) {
            BasePageIterator pageIterator = this.pageIterator();
            while (!pageIterator.hasNext()) {
                DataPage page = this.pageSource.readPage();
                if (page != null) {
                    pageIterator.setPage(page);
                    this.advanceNextPageCount += (long)pageIterator.currentPageCount();
                    continue;
                }
                return;
            }
        }
    }

    public boolean hasNext() {
        return this.triplesRead < this.triplesCount;
    }
}

