/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.parquet;

import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.parquet.bytes.ByteBufferInputStream;
import com.dataiku.dss.shadelib.org.apache.parquet.bytes.BytesInput;
import com.dataiku.dss.shadelib.org.apache.parquet.bytes.BytesUtils;
import com.dataiku.dss.shadelib.org.apache.parquet.column.ColumnDescriptor;
import com.dataiku.dss.shadelib.org.apache.parquet.column.Dictionary;
import com.dataiku.dss.shadelib.org.apache.parquet.column.Encoding;
import com.dataiku.dss.shadelib.org.apache.parquet.column.ValuesType;
import com.dataiku.dss.shadelib.org.apache.parquet.column.page.DataPage;
import com.dataiku.dss.shadelib.org.apache.parquet.column.page.DataPageV1;
import com.dataiku.dss.shadelib.org.apache.parquet.column.page.DataPageV2;
import com.dataiku.dss.shadelib.org.apache.parquet.column.values.ValuesReader;
import com.dataiku.dss.shadelib.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import com.dataiku.dss.shadelib.org.apache.parquet.io.ParquetDecodingException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePageIterator {
    private static final Logger LOG = LoggerFactory.getLogger(BasePageIterator.class);
    protected final ColumnDescriptor desc;
    protected final String writerVersion;
    protected boolean hasNext = false;
    protected int triplesRead = 0;
    protected int currentDL = 0;
    protected int currentRL = 0;
    protected Dictionary dictionary = null;
    protected DataPage page = null;
    protected int triplesCount = 0;
    protected Encoding valueEncoding = null;
    protected IntIterator definitionLevels = null;
    protected IntIterator repetitionLevels = null;
    protected ValuesReader values = null;

    protected BasePageIterator(ColumnDescriptor descriptor, String writerVersion) {
        this.desc = descriptor;
        this.writerVersion = writerVersion;
    }

    protected void reset() {
        this.page = null;
        this.triplesCount = 0;
        this.triplesRead = 0;
        this.repetitionLevels = null;
        this.hasNext = false;
    }

    protected abstract void initDataReader(Encoding var1, ByteBufferInputStream var2, int var3);

    protected abstract void initDefinitionLevelsReader(DataPageV1 var1, ColumnDescriptor var2, ByteBufferInputStream var3, int var4) throws IOException;

    protected abstract void initDefinitionLevelsReader(DataPageV2 var1, ColumnDescriptor var2) throws IOException;

    protected void initRepetitionLevelsReader(DataPageV1 dataPageV1, ColumnDescriptor descriptor, ByteBufferInputStream in, int count) throws IOException {
        ValuesReader rlReader = dataPageV1.getRlEncoding().getValuesReader(descriptor, ValuesType.REPETITION_LEVEL);
        this.repetitionLevels = new ValuesReaderIntIterator(rlReader);
        rlReader.initFromPage(count, in);
    }

    protected void initRepetitionLevelsReader(DataPageV2 dataPageV2, ColumnDescriptor descriptor) throws IOException {
        this.repetitionLevels = this.newRLEIterator(descriptor.getMaxRepetitionLevel(), dataPageV2.getRepetitionLevels());
    }

    public int currentPageCount() {
        return this.triplesCount;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public void setPage(DataPage page) {
        Preconditions.checkNotNull(page, "Cannot read from null page");
        this.page = page;
        this.page.accept(new DataPage.Visitor<ValuesReader>(){

            @Override
            public ValuesReader visit(DataPageV1 dataPageV1) {
                BasePageIterator.this.initFromPage(dataPageV1);
                return null;
            }

            @Override
            public ValuesReader visit(DataPageV2 dataPageV2) {
                BasePageIterator.this.initFromPage(dataPageV2);
                return null;
            }
        });
        this.triplesRead = 0;
        this.hasNext = this.triplesRead < this.triplesCount;
    }

    protected void initFromPage(DataPageV1 initPage) {
        this.triplesCount = initPage.getValueCount();
        try {
            BytesInput bytes = initPage.getBytes();
            LOG.debug("page size {} bytes and {} records", (Object)bytes.size(), (Object)this.triplesCount);
            LOG.debug("reading repetition levels at 0");
            ByteBufferInputStream in = bytes.toInputStream();
            this.initRepetitionLevelsReader(initPage, this.desc, in, this.triplesCount);
            LOG.debug("reading definition levels at {}", (Object)in.position());
            this.initDefinitionLevelsReader(initPage, this.desc, in, this.triplesCount);
            LOG.debug("reading data at {}", (Object)in.position());
            this.initDataReader(initPage.getValueEncoding(), in, initPage.getValueCount());
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read page " + String.valueOf(initPage) + " in col " + String.valueOf(this.desc), e);
        }
    }

    protected void initFromPage(DataPageV2 initPage) {
        this.triplesCount = initPage.getValueCount();
        try {
            this.initRepetitionLevelsReader(initPage, this.desc);
            this.initDefinitionLevelsReader(initPage, this.desc);
            LOG.debug("page data size {} bytes and {} records", (Object)initPage.getData().size(), (Object)this.triplesCount);
            this.initDataReader(initPage.getDataEncoding(), initPage.getData().toInputStream(), this.triplesCount);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read page " + String.valueOf(initPage) + " in col " + String.valueOf(this.desc), e);
        }
    }

    public void setDictionary(Dictionary dict) {
        this.dictionary = dict;
    }

    IntIterator newRLEIterator(int maxLevel, BytesInput bytes) {
        try {
            if (maxLevel == 0) {
                return new NullIntIterator();
            }
            return new RLEIntIterator(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt(maxLevel), bytes.toInputStream()));
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read levels in page for col " + String.valueOf(this.desc), e);
        }
    }

    protected static abstract class IntIterator {
        protected IntIterator() {
        }

        abstract int nextInt();
    }

    static class ValuesReaderIntIterator
    extends IntIterator {
        private final ValuesReader delegate;

        ValuesReaderIntIterator(ValuesReader delegate) {
            this.delegate = delegate;
        }

        @Override
        int nextInt() {
            return this.delegate.readInteger();
        }
    }

    static final class NullIntIterator
    extends IntIterator {
        NullIntIterator() {
        }

        @Override
        int nextInt() {
            return 0;
        }
    }

    static class RLEIntIterator
    extends IntIterator {
        private final RunLengthBitPackingHybridDecoder delegate;

        RLEIntIterator(RunLengthBitPackingHybridDecoder delegate) {
            this.delegate = delegate;
        }

        @Override
        int nextInt() {
            try {
                return this.delegate.readInt();
            }
            catch (IOException e) {
                throw new ParquetDecodingException(e);
            }
        }
    }
}

