/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.parquet;

import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.ParquetSchemaUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.GroupType;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.LogicalTypeAnnotation;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.PrimitiveType;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.Type;
import java.util.ArrayList;
import java.util.List;

public abstract class ParquetVariantVisitor<R> {
    static final String METADATA = "metadata";
    static final String VALUE = "value";
    static final String TYPED_VALUE = "typed_value";
    static final String LIST = "list";

    public R variant(GroupType variant, R metadataResult, R valueResult) {
        return null;
    }

    public R metadata(PrimitiveType metadata) {
        return null;
    }

    public R serialized(PrimitiveType value) {
        return null;
    }

    public R primitive(PrimitiveType primitive) {
        return null;
    }

    public R value(GroupType value, R valueResult, R typedResult) {
        return null;
    }

    public R object(GroupType object, R valueResult, List<R> fieldResults) {
        return null;
    }

    public R array(GroupType array, R valueResult, R elementResult) {
        return null;
    }

    public void beforeField(Type type) {
    }

    public void afterField(Type type) {
    }

    public static <R> R visit(GroupType type, ParquetVariantVisitor<R> visitor) {
        Preconditions.checkArgument(ParquetSchemaUtil.hasField(type, METADATA), "Invalid variant, missing metadata: %s", (Object)type);
        Type metadataType = type.getType(METADATA);
        Preconditions.checkArgument(ParquetVariantVisitor.isBinary(metadataType), "Invalid variant metadata, expecting BINARY: %s", (Object)metadataType);
        Object metadataResult = ParquetVariantVisitor.withBeforeAndAfter(() -> visitor.metadata(metadataType.asPrimitiveType()), metadataType, visitor);
        R valueResult = ParquetVariantVisitor.visitValue(type, visitor);
        return (R)visitor.variant(type, metadataResult, valueResult);
    }

    private static <R> R visitValue(GroupType valueGroup, ParquetVariantVisitor<R> visitor) {
        Object valueResult;
        if (ParquetSchemaUtil.hasField(valueGroup, VALUE)) {
            Type valueType = valueGroup.getType(VALUE);
            Preconditions.checkArgument(ParquetVariantVisitor.isBinary(valueType), "Invalid variant value, expecting BINARY: %s", (Object)valueType);
            valueResult = ParquetVariantVisitor.withBeforeAndAfter(() -> visitor.serialized(valueType.asPrimitiveType()), valueType, visitor);
        } else {
            Preconditions.checkArgument(ParquetSchemaUtil.hasField(valueGroup, TYPED_VALUE), "Invalid variant, missing both value and typed_value: %s", (Object)valueGroup);
            valueResult = null;
        }
        if (ParquetSchemaUtil.hasField(valueGroup, TYPED_VALUE)) {
            Type typedValueType = valueGroup.getType(TYPED_VALUE);
            if (typedValueType.isPrimitive()) {
                Object typedResult = ParquetVariantVisitor.withBeforeAndAfter(() -> visitor.primitive(typedValueType.asPrimitiveType()), typedValueType, visitor);
                return (R)visitor.value(valueGroup, valueResult, typedResult);
            }
            if (typedValueType.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
                Object elementResult = ParquetVariantVisitor.withBeforeAndAfter(() -> ParquetVariantVisitor.visitArray(typedValueType.asGroupType(), visitor), typedValueType, visitor);
                return (R)visitor.array(valueGroup, valueResult, elementResult);
            }
            List results = ParquetVariantVisitor.withBeforeAndAfter(() -> ParquetVariantVisitor.visitObjectFields(typedValueType.asGroupType(), visitor), typedValueType, visitor);
            return (R)visitor.object(valueGroup, valueResult, results);
        }
        return visitor.value(valueGroup, valueResult, null);
    }

    private static <R> R visitArray(GroupType array, ParquetVariantVisitor<R> visitor) {
        Preconditions.checkArgument(array.getFieldCount() == 1, "Invalid variant array: does not contain single repeated field: %s", (Object)array);
        Type repeated = array.getFields().get(0);
        Preconditions.checkArgument(repeated.isRepetition(Type.Repetition.REPEATED), "Invalid variant array: inner group is not repeated");
        return (R)ParquetVariantVisitor.withBeforeAndAfter(() -> ParquetVariantVisitor.visitElement(repeated.asGroupType().getType(0), visitor), repeated, visitor);
    }

    private static <R> R visitElement(Type element, ParquetVariantVisitor<R> visitor) {
        return (R)ParquetVariantVisitor.withBeforeAndAfter(() -> ParquetVariantVisitor.visitValue(element.asGroupType(), visitor), element, visitor);
    }

    private static <R> List<R> visitObjectFields(GroupType fields, ParquetVariantVisitor<R> visitor) {
        ArrayList<Object> results = Lists.newArrayList();
        for (Type fieldType : fields.getFields()) {
            Preconditions.checkArgument(!fieldType.isPrimitive(), "Invalid shredded object field, not a group: %s", (Object)fieldType);
            Object fieldResult = ParquetVariantVisitor.withBeforeAndAfter(() -> ParquetVariantVisitor.visitValue(fieldType.asGroupType(), visitor), fieldType, visitor);
            results.add(fieldResult);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R> R withBeforeAndAfter(Action<R> task, Type type, ParquetVariantVisitor<?> visitor) {
        visitor.beforeField(type);
        try {
            R r = task.invoke();
            return r;
        }
        finally {
            visitor.afterField(type);
        }
    }

    private static boolean isBinary(Type type) {
        return type.isPrimitive() && type.asPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY;
    }

    @FunctionalInterface
    private static interface Action<R> {
        public R invoke();
    }
}

