/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.parquet;

import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.avro.AvroSchemaUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.TypeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.GroupType;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.LogicalTypeAnnotation;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.MessageType;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.PrimitiveType;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.Type;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.Types;
import java.util.function.BiFunction;

public class TypeToMessageType {
    public static final int DECIMAL_INT32_MAX_DIGITS = 9;
    public static final int DECIMAL_INT64_MAX_DIGITS = 18;
    private static final LogicalTypeAnnotation STRING = LogicalTypeAnnotation.stringType();
    private static final LogicalTypeAnnotation DATE = LogicalTypeAnnotation.dateType();
    private static final LogicalTypeAnnotation TIME_MICROS = LogicalTypeAnnotation.timeType(false, LogicalTypeAnnotation.TimeUnit.MICROS);
    private static final LogicalTypeAnnotation TIMESTAMP_MICROS = LogicalTypeAnnotation.timestampType(false, LogicalTypeAnnotation.TimeUnit.MICROS);
    private static final LogicalTypeAnnotation TIMESTAMPTZ_MICROS = LogicalTypeAnnotation.timestampType(true, LogicalTypeAnnotation.TimeUnit.MICROS);
    private static final LogicalTypeAnnotation TIMESTAMP_NANOS = LogicalTypeAnnotation.timestampType(false, LogicalTypeAnnotation.TimeUnit.NANOS);
    private static final LogicalTypeAnnotation TIMESTAMPTZ_NANOS = LogicalTypeAnnotation.timestampType(true, LogicalTypeAnnotation.TimeUnit.NANOS);
    private static final String METADATA = "metadata";
    private static final String VALUE = "value";
    private static final String TYPED_VALUE = "typed_value";
    private final BiFunction<Integer, String, Type> variantShreddingFunc;

    public TypeToMessageType() {
        this.variantShreddingFunc = null;
    }

    TypeToMessageType(BiFunction<Integer, String, Type> variantShreddingFunc) {
        this.variantShreddingFunc = variantShreddingFunc;
    }

    public MessageType convert(Schema schema, String name) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        for (Types.NestedField field : schema.columns()) {
            Type fieldType = this.field(field);
            if (fieldType == null) continue;
            builder.addField(fieldType);
        }
        return builder.named(AvroSchemaUtil.makeCompatibleName(name));
    }

    public GroupType struct(Types.StructType struct, Type.Repetition repetition, int id, String name) {
        Types.GroupBuilder<GroupType> builder = Types.buildGroup(repetition);
        for (Types.NestedField field : struct.fields()) {
            Type fieldType = this.field(field);
            if (fieldType == null) continue;
            builder.addField(fieldType);
        }
        return (GroupType)((Types.GroupBuilder)builder.id(id)).named(AvroSchemaUtil.makeCompatibleName(name));
    }

    public Type field(Types.NestedField field) {
        Type.Repetition repetition = field.isOptional() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED;
        int id = field.fieldId();
        String name = field.name();
        if (field.type().typeId() == Type.TypeID.UNKNOWN) {
            return null;
        }
        if (field.type().isPrimitiveType()) {
            return this.primitive(field.type().asPrimitiveType(), repetition, id, name);
        }
        if (field.type().isVariantType()) {
            return this.variant(repetition, id, name);
        }
        Type.NestedType nested = field.type().asNestedType();
        if (nested.isStructType()) {
            return this.struct(nested.asStructType(), repetition, id, name);
        }
        if (nested.isMapType()) {
            return this.map(nested.asMapType(), repetition, id, name);
        }
        if (nested.isListType()) {
            return this.list(nested.asListType(), repetition, id, name);
        }
        throw new UnsupportedOperationException("Can't convert unknown type: " + String.valueOf(nested));
    }

    public GroupType list(Types.ListType list, Type.Repetition repetition, int id, String name) {
        Types.NestedField elementField = list.fields().get(0);
        Type elementType = this.field(elementField);
        Preconditions.checkArgument(elementType != null, "Cannot convert element Parquet: %s", (Object)elementField.type());
        return (GroupType)((Types.ListBuilder)Types.list(repetition).element(elementType).id(id)).named(AvroSchemaUtil.makeCompatibleName(name));
    }

    public GroupType map(Types.MapType map, Type.Repetition repetition, int id, String name) {
        Types.NestedField keyField = map.fields().get(0);
        Types.NestedField valueField = map.fields().get(1);
        Type keyType = this.field(keyField);
        Preconditions.checkArgument(keyType != null, "Cannot convert key Parquet: %s", (Object)keyField.type());
        Type valueType = this.field(valueField);
        Preconditions.checkArgument(valueType != null, "Cannot convert value Parquet: %s", (Object)valueField.type());
        return (GroupType)((Types.MapBuilder)((Types.MapBuilder)((Types.MapBuilder)Types.map(repetition).key(this.field(keyField))).value(this.field(valueField))).id(id)).named(AvroSchemaUtil.makeCompatibleName(name));
    }

    public Type variant(Type.Repetition repetition, int id, String originalName) {
        String name = AvroSchemaUtil.makeCompatibleName(originalName);
        Type shreddedType = this.variantShreddingFunc != null ? this.variantShreddingFunc.apply(id, originalName) : null;
        if (shreddedType != null) {
            Preconditions.checkArgument(shreddedType.getName().equals(TYPED_VALUE), "Invalid shredded type name: %s should be typed_value", (Object)shreddedType.getName());
            Preconditions.checkArgument(shreddedType.isRepetition(Type.Repetition.OPTIONAL), "Invalid shredded type repetition: %s should be OPTIONAL", (Object)shreddedType.getRepetition());
            return (Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup(repetition).as(LogicalTypeAnnotation.variantType((byte)1))).id(id)).required(PrimitiveType.PrimitiveTypeName.BINARY).named(METADATA)).optional(PrimitiveType.PrimitiveTypeName.BINARY).named(VALUE)).addField(shreddedType)).named(name);
        }
        return (Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup(repetition).as(LogicalTypeAnnotation.variantType((byte)1))).id(id)).required(PrimitiveType.PrimitiveTypeName.BINARY).named(METADATA)).required(PrimitiveType.PrimitiveTypeName.BINARY).named(VALUE)).named(name);
    }

    public Type primitive(Type.PrimitiveType primitive, Type.Repetition repetition, int id, String originalName) {
        String name = AvroSchemaUtil.makeCompatibleName(originalName);
        switch (primitive.typeId()) {
            case BOOLEAN: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition).id(id)).named(name);
            }
            case INTEGER: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).id(id)).named(name);
            }
            case LONG: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).id(id)).named(name);
            }
            case FLOAT: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.FLOAT, repetition).id(id)).named(name);
            }
            case DOUBLE: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE, repetition).id(id)).named(name);
            }
            case DATE: {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(DATE)).id(id)).named(name);
            }
            case TIME: {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(TIME_MICROS)).id(id)).named(name);
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)primitive).shouldAdjustToUTC()) {
                    return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(TIMESTAMPTZ_MICROS)).id(id)).named(name);
                }
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(TIMESTAMP_MICROS)).id(id)).named(name);
            }
            case TIMESTAMP_NANO: {
                if (((Types.TimestampNanoType)primitive).shouldAdjustToUTC()) {
                    return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(TIMESTAMPTZ_NANOS)).id(id)).named(name);
                }
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(TIMESTAMP_NANOS)).id(id)).named(name);
            }
            case STRING: {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(STRING)).id(id)).named(name);
            }
            case BINARY: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).id(id)).named(name);
            }
            case FIXED: {
                Types.FixedType fixed = (Types.FixedType)primitive;
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition).length(fixed.length())).id(id)).named(name);
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)primitive;
                if (decimal.precision() <= 9) {
                    return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(TypeToMessageType.decimalAnnotation(decimal.precision(), decimal.scale()))).id(id)).named(name);
                }
                if (decimal.precision() <= 18) {
                    return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(TypeToMessageType.decimalAnnotation(decimal.precision(), decimal.scale()))).id(id)).named(name);
                }
                int minLength = TypeUtil.decimalRequiredBytes(decimal.precision());
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition).length(minLength)).as(TypeToMessageType.decimalAnnotation(decimal.precision(), decimal.scale()))).id(id)).named(name);
            }
            case UUID: {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition).length(16)).as(LogicalTypeAnnotation.uuidType())).id(id)).named(name);
            }
        }
        throw new UnsupportedOperationException("Unsupported type for Parquet: " + String.valueOf(primitive));
    }

    private static LogicalTypeAnnotation decimalAnnotation(int precision, int scale) {
        return LogicalTypeAnnotation.decimalType(scale, precision);
    }
}

