/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest;

import com.dataiku.dss.shadelib.org.apache.hc.client5.http.HttpRequestRetryStrategy;
import com.dataiku.dss.shadelib.org.apache.hc.client5.http.utils.DateUtils;
import com.dataiku.dss.shadelib.org.apache.hc.core5.concurrent.CancellableDependency;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.ConnectionClosedException;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.Header;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.HttpRequest;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.Method;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.protocol.HttpContext;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.protocol.HttpCoreContext;
import com.dataiku.dss.shadelib.org.apache.hc.core5.util.TimeValue;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ssl.SSLException;

class ExponentialHttpRequestRetryStrategy
implements HttpRequestRetryStrategy {
    private final int maxRetries;
    private final Set<Class<? extends IOException>> nonRetriableExceptions;
    private final Set<Integer> retriableCodes;
    private final Set<Integer> idempotentRetriableCodes;

    ExponentialHttpRequestRetryStrategy(int maximumRetries) {
        Preconditions.checkArgument(maximumRetries > 0, "Cannot set retries to %s, the value must be positive", maximumRetries);
        this.maxRetries = maximumRetries;
        this.retriableCodes = ImmutableSet.of(Integer.valueOf(429));
        this.idempotentRetriableCodes = ImmutableSet.of(Integer.valueOf(429), Integer.valueOf(503), Integer.valueOf(500), Integer.valueOf(502), Integer.valueOf(504), Integer.valueOf(408), new Integer[0]);
        this.nonRetriableExceptions = ImmutableSet.of(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, ConnectionClosedException.class, NoRouteToHostException.class, SSLException.class, new Class[0]);
    }

    @Override
    public boolean retryRequest(HttpRequest request, IOException exception, int execCount, HttpContext context) {
        if (execCount > this.maxRetries) {
            return false;
        }
        if (this.nonRetriableExceptions.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : this.nonRetriableExceptions) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        if (request instanceof CancellableDependency && ((CancellableDependency)((Object)request)).isCancelled()) {
            return false;
        }
        return Method.isIdempotent(request.getMethod());
    }

    @Override
    public boolean retryRequest(HttpResponse response, int execCount, HttpContext context) {
        HttpRequest request = context instanceof HttpCoreContext ? ((HttpCoreContext)context).getRequest() : null;
        boolean is503Retryable = response.getCode() == 503 && response.getFirstHeader("Retry-After") != null;
        return execCount <= this.maxRetries && (this.retriableCodes.contains(response.getCode()) || this.shouldRetryIdempotent(request, response.getCode()) || is503Retryable);
    }

    @Override
    public TimeValue getRetryInterval(HttpResponse response, int execCount, HttpContext context) {
        Header header = response.getFirstHeader("Retry-After");
        TimeValue retryAfter = null;
        if (header != null) {
            block4: {
                String value = header.getValue();
                try {
                    retryAfter = TimeValue.ofSeconds(Long.parseLong(value));
                }
                catch (NumberFormatException ignore) {
                    Instant retryAfterDate = DateUtils.parseStandardDate(value);
                    if (retryAfterDate == null) break block4;
                    retryAfter = TimeValue.ofMilliseconds(retryAfterDate.toEpochMilli() - System.currentTimeMillis());
                }
            }
            if (TimeValue.isPositive(retryAfter)) {
                return retryAfter;
            }
        }
        int delayMillis = 1000 * (int)Math.min(Math.pow(2.0, (double)execCount - 1.0), 64.0);
        int jitter = ThreadLocalRandom.current().nextInt(Math.max(1, (int)((double)delayMillis * 0.1)));
        return TimeValue.ofMilliseconds(delayMillis + jitter);
    }

    private boolean shouldRetryIdempotent(HttpRequest request, int responseCode) {
        if (request == null) {
            return false;
        }
        return Method.isIdempotent(request.getMethod()) && this.idempotentRetriableCodes.contains(responseCode);
    }
}

