/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonParser;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.DeserializationContext;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonDeserializer;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonSerializer;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.SerializerProvider;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.module.SimpleModule;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataUpdate;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataUpdateParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpecParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SchemaParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.SortOrderParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadataParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.UnboundPartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.UnboundSortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateRequirement;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateRequirementParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifierParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.OAuth2Util;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.CommitTransactionRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.CommitTransactionRequestParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.CreateViewRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.CreateViewRequestParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.FetchScanTasksRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.FetchScanTasksRequestParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.ImmutableCreateViewRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.ImmutableRegisterTableRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.ImmutableReportMetricsRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.PlanTableScanRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.PlanTableScanRequestParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.RegisterTableRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.RegisterTableRequestParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.ReportMetricsRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.ReportMetricsRequestParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.UpdateTableRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.UpdateTableRequestParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.ConfigResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.ConfigResponseParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.ErrorResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.ErrorResponseParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.FetchPlanningResultResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.FetchPlanningResultResponseParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.FetchScanTasksResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.FetchScanTasksResponseParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.ImmutableLoadCredentialsResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.ImmutableLoadViewResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.LoadCredentialsResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.LoadCredentialsResponseParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.LoadTableResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.LoadTableResponseParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.LoadViewResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.LoadViewResponseParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.OAuthTokenResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.PlanTableScanResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.PlanTableScanResponseParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import java.io.IOException;
import java.util.Map;

public class RESTSerializers {
    private RESTSerializers() {
    }

    public static void registerAll(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(ErrorResponse.class, new ErrorResponseSerializer()).addDeserializer(ErrorResponse.class, new ErrorResponseDeserializer()).addSerializer(TableIdentifier.class, new TableIdentifierSerializer()).addDeserializer(TableIdentifier.class, new TableIdentifierDeserializer()).addSerializer(Namespace.class, new NamespaceSerializer()).addDeserializer(Namespace.class, new NamespaceDeserializer()).addSerializer(Schema.class, new SchemaSerializer()).addDeserializer(Schema.class, new SchemaDeserializer()).addSerializer(UnboundPartitionSpec.class, new UnboundPartitionSpecSerializer()).addDeserializer(UnboundPartitionSpec.class, new UnboundPartitionSpecDeserializer()).addSerializer(UnboundSortOrder.class, new UnboundSortOrderSerializer()).addDeserializer(UnboundSortOrder.class, new UnboundSortOrderDeserializer()).addSerializer(MetadataUpdate.class, new MetadataUpdateSerializer()).addDeserializer(MetadataUpdate.class, new MetadataUpdateDeserializer()).addSerializer(TableMetadata.class, new TableMetadataSerializer()).addDeserializer(TableMetadata.class, new TableMetadataDeserializer()).addSerializer(UpdateRequirement.class, new UpdateReqSerializer()).addDeserializer(UpdateRequirement.class, new UpdateReqDeserializer()).addSerializer(OAuthTokenResponse.class, new OAuthTokenResponseSerializer()).addDeserializer(OAuthTokenResponse.class, new OAuthTokenResponseDeserializer()).addSerializer(ReportMetricsRequest.class, new ReportMetricsRequestSerializer()).addDeserializer(ReportMetricsRequest.class, new ReportMetricsRequestDeserializer()).addSerializer(ImmutableReportMetricsRequest.class, new ReportMetricsRequestSerializer()).addDeserializer(ImmutableReportMetricsRequest.class, new ReportMetricsRequestDeserializer()).addSerializer(CommitTransactionRequest.class, new CommitTransactionRequestSerializer()).addDeserializer(CommitTransactionRequest.class, new CommitTransactionRequestDeserializer()).addSerializer(UpdateTableRequest.class, new UpdateTableRequestSerializer()).addDeserializer(UpdateTableRequest.class, new UpdateTableRequestDeserializer()).addSerializer(RegisterTableRequest.class, new RegisterTableRequestSerializer()).addDeserializer(RegisterTableRequest.class, new RegisterTableRequestDeserializer()).addSerializer(ImmutableRegisterTableRequest.class, new RegisterTableRequestSerializer()).addDeserializer(ImmutableRegisterTableRequest.class, new RegisterTableRequestDeserializer()).addSerializer(CreateViewRequest.class, new CreateViewRequestSerializer()).addSerializer(ImmutableCreateViewRequest.class, new CreateViewRequestSerializer()).addDeserializer(CreateViewRequest.class, new CreateViewRequestDeserializer()).addDeserializer(ImmutableCreateViewRequest.class, new CreateViewRequestDeserializer()).addSerializer(LoadViewResponse.class, new LoadViewResponseSerializer()).addSerializer(ImmutableLoadViewResponse.class, new LoadViewResponseSerializer()).addDeserializer(LoadViewResponse.class, new LoadViewResponseDeserializer()).addDeserializer(ImmutableLoadViewResponse.class, new LoadViewResponseDeserializer()).addSerializer(ConfigResponse.class, new ConfigResponseSerializer()).addDeserializer(ConfigResponse.class, new ConfigResponseDeserializer()).addSerializer(LoadTableResponse.class, new LoadTableResponseSerializer()).addDeserializer(LoadTableResponse.class, new LoadTableResponseDeserializer()).addSerializer(PlanTableScanRequest.class, new PlanTableScanRequestSerializer()).addDeserializer(PlanTableScanRequest.class, new PlanTableScanRequestDeserializer()).addSerializer(FetchScanTasksRequest.class, new FetchScanTasksRequestSerializer()).addDeserializer(FetchScanTasksRequest.class, new FetchScanTasksRequestDeserializer()).addSerializer(PlanTableScanResponse.class, new PlanTableScanResponseSerializer()).addDeserializer(PlanTableScanResponse.class, new PlanTableScanResponseDeserializer()).addSerializer(FetchPlanningResultResponse.class, new FetchPlanningResultResponseSerializer()).addDeserializer(FetchPlanningResultResponse.class, new FetchPlanningResultResponseDeserializer()).addSerializer(FetchScanTasksResponse.class, new FetchScanTaskResponseSerializer()).addDeserializer(FetchScanTasksResponse.class, new FetchScanTaskResponseDeserializer()).addSerializer(LoadCredentialsResponse.class, new LoadCredentialsResponseSerializer()).addSerializer(ImmutableLoadCredentialsResponse.class, new LoadCredentialsResponseSerializer()).addDeserializer(LoadCredentialsResponse.class, new LoadCredentialsResponseDeserializer()).addDeserializer(ImmutableLoadCredentialsResponse.class, new LoadCredentialsResponseDeserializer());
        mapper.registerModule(module);
    }

    private static TableScanResponseContext parseScanResponseContext(DeserializationContext context) throws IOException {
        Map specsById = (Map)context.findInjectableValue("specsById", null, null);
        boolean caseSensitive = (Boolean)context.findInjectableValue("caseSensitive", null, null);
        return new TableScanResponseContext(specsById, caseSensitive);
    }

    public static class ErrorResponseSerializer
    extends JsonSerializer<ErrorResponse> {
        @Override
        public void serialize(ErrorResponse errorResponse, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            ErrorResponseParser.toJson(errorResponse, gen);
        }
    }

    public static class ErrorResponseDeserializer
    extends JsonDeserializer<ErrorResponse> {
        @Override
        public ErrorResponse deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return ErrorResponseParser.fromJson(node);
        }
    }

    public static class TableIdentifierSerializer
    extends JsonSerializer<TableIdentifier> {
        @Override
        public void serialize(TableIdentifier identifier, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            TableIdentifierParser.toJson(identifier, gen);
        }
    }

    public static class TableIdentifierDeserializer
    extends JsonDeserializer<TableIdentifier> {
        @Override
        public TableIdentifier deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return TableIdentifierParser.fromJson(jsonNode);
        }
    }

    public static class NamespaceSerializer
    extends JsonSerializer<Namespace> {
        @Override
        public void serialize(Namespace namespace, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String[] parts = namespace.levels();
            gen.writeArray(parts, 0, parts.length);
        }
    }

    public static class NamespaceDeserializer
    extends JsonDeserializer<Namespace> {
        @Override
        public Namespace deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String[] levels = JsonUtil.getStringArray((JsonNode)p.getCodec().readTree(p));
            return Namespace.of(levels);
        }
    }

    public static class SchemaSerializer
    extends JsonSerializer<Schema> {
        @Override
        public void serialize(Schema schema, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            SchemaParser.toJson(schema, gen);
        }
    }

    public static class SchemaDeserializer
    extends JsonDeserializer<Schema> {
        @Override
        public Schema deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return SchemaParser.fromJson(jsonNode);
        }
    }

    public static class UnboundPartitionSpecSerializer
    extends JsonSerializer<UnboundPartitionSpec> {
        @Override
        public void serialize(UnboundPartitionSpec spec, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            PartitionSpecParser.toJson(spec, gen);
        }
    }

    public static class UnboundPartitionSpecDeserializer
    extends JsonDeserializer<UnboundPartitionSpec> {
        @Override
        public UnboundPartitionSpec deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return PartitionSpecParser.fromJson(jsonNode);
        }
    }

    public static class UnboundSortOrderSerializer
    extends JsonSerializer<UnboundSortOrder> {
        @Override
        public void serialize(UnboundSortOrder sortOrder, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            SortOrderParser.toJson(sortOrder, gen);
        }
    }

    public static class UnboundSortOrderDeserializer
    extends JsonDeserializer<UnboundSortOrder> {
        @Override
        public UnboundSortOrder deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return SortOrderParser.fromJson(jsonNode);
        }
    }

    public static class MetadataUpdateSerializer
    extends JsonSerializer<MetadataUpdate> {
        @Override
        public void serialize(MetadataUpdate value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            MetadataUpdateParser.toJson(value, gen);
        }
    }

    public static class MetadataUpdateDeserializer
    extends JsonDeserializer<MetadataUpdate> {
        @Override
        public MetadataUpdate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return MetadataUpdateParser.fromJson(node);
        }
    }

    public static class TableMetadataSerializer
    extends JsonSerializer<TableMetadata> {
        @Override
        public void serialize(TableMetadata metadata, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            TableMetadataParser.toJson(metadata, gen);
        }
    }

    public static class TableMetadataDeserializer
    extends JsonDeserializer<TableMetadata> {
        @Override
        public TableMetadata deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return TableMetadataParser.fromJson(node);
        }
    }

    static class UpdateReqSerializer
    extends JsonSerializer<UpdateRequirement> {
        UpdateReqSerializer() {
        }

        @Override
        public void serialize(UpdateRequirement value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            UpdateRequirementParser.toJson(value, gen);
        }
    }

    static class UpdateReqDeserializer
    extends JsonDeserializer<UpdateRequirement> {
        UpdateReqDeserializer() {
        }

        @Override
        public UpdateRequirement deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return UpdateRequirementParser.fromJson(node);
        }
    }

    public static class OAuthTokenResponseSerializer
    extends JsonSerializer<OAuthTokenResponse> {
        @Override
        public void serialize(OAuthTokenResponse tokenResponse, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            OAuth2Util.tokenResponseToJson(tokenResponse, gen);
        }
    }

    public static class OAuthTokenResponseDeserializer
    extends JsonDeserializer<OAuthTokenResponse> {
        @Override
        public OAuthTokenResponse deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return OAuth2Util.tokenResponseFromJson(jsonNode);
        }
    }

    public static class ReportMetricsRequestSerializer<T extends ReportMetricsRequest>
    extends JsonSerializer<T> {
        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            ReportMetricsRequestParser.toJson(request, gen);
        }
    }

    public static class ReportMetricsRequestDeserializer<T extends ReportMetricsRequest>
    extends JsonDeserializer<T> {
        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)ReportMetricsRequestParser.fromJson(jsonNode);
        }
    }

    public static class CommitTransactionRequestSerializer
    extends JsonSerializer<CommitTransactionRequest> {
        @Override
        public void serialize(CommitTransactionRequest request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            CommitTransactionRequestParser.toJson(request, gen);
        }
    }

    public static class CommitTransactionRequestDeserializer
    extends JsonDeserializer<CommitTransactionRequest> {
        @Override
        public CommitTransactionRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return CommitTransactionRequestParser.fromJson(jsonNode);
        }
    }

    public static class UpdateTableRequestSerializer
    extends JsonSerializer<UpdateTableRequest> {
        @Override
        public void serialize(UpdateTableRequest request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            UpdateTableRequestParser.toJson(request, gen);
        }
    }

    public static class UpdateTableRequestDeserializer
    extends JsonDeserializer<UpdateTableRequest> {
        @Override
        public UpdateTableRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return UpdateTableRequestParser.fromJson(jsonNode);
        }
    }

    public static class RegisterTableRequestSerializer<T extends RegisterTableRequest>
    extends JsonSerializer<T> {
        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            RegisterTableRequestParser.toJson(request, gen);
        }
    }

    public static class RegisterTableRequestDeserializer<T extends RegisterTableRequest>
    extends JsonDeserializer<T> {
        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)RegisterTableRequestParser.fromJson(jsonNode);
        }
    }

    static class CreateViewRequestSerializer<T extends CreateViewRequest>
    extends JsonSerializer<T> {
        CreateViewRequestSerializer() {
        }

        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            CreateViewRequestParser.toJson(request, gen);
        }
    }

    static class CreateViewRequestDeserializer<T extends CreateViewRequest>
    extends JsonDeserializer<T> {
        CreateViewRequestDeserializer() {
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)CreateViewRequestParser.fromJson(jsonNode);
        }
    }

    static class LoadViewResponseSerializer<T extends LoadViewResponse>
    extends JsonSerializer<T> {
        LoadViewResponseSerializer() {
        }

        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            LoadViewResponseParser.toJson(request, gen);
        }
    }

    static class LoadViewResponseDeserializer<T extends LoadViewResponse>
    extends JsonDeserializer<T> {
        LoadViewResponseDeserializer() {
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)LoadViewResponseParser.fromJson(jsonNode);
        }
    }

    static class ConfigResponseSerializer<T extends ConfigResponse>
    extends JsonSerializer<T> {
        ConfigResponseSerializer() {
        }

        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            ConfigResponseParser.toJson(request, gen);
        }
    }

    static class ConfigResponseDeserializer<T extends ConfigResponse>
    extends JsonDeserializer<T> {
        ConfigResponseDeserializer() {
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)ConfigResponseParser.fromJson(jsonNode);
        }
    }

    static class LoadTableResponseSerializer<T extends LoadTableResponse>
    extends JsonSerializer<T> {
        LoadTableResponseSerializer() {
        }

        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            LoadTableResponseParser.toJson(request, gen);
        }
    }

    static class LoadTableResponseDeserializer<T extends LoadTableResponse>
    extends JsonDeserializer<T> {
        LoadTableResponseDeserializer() {
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)LoadTableResponseParser.fromJson(jsonNode);
        }
    }

    static class PlanTableScanRequestSerializer<T extends PlanTableScanRequest>
    extends JsonSerializer<T> {
        PlanTableScanRequestSerializer() {
        }

        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            PlanTableScanRequestParser.toJson(request, gen);
        }
    }

    static class PlanTableScanRequestDeserializer<T extends PlanTableScanRequest>
    extends JsonDeserializer<T> {
        PlanTableScanRequestDeserializer() {
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)PlanTableScanRequestParser.fromJson(jsonNode);
        }
    }

    static class FetchScanTasksRequestSerializer<T extends FetchScanTasksRequest>
    extends JsonSerializer<T> {
        FetchScanTasksRequestSerializer() {
        }

        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            FetchScanTasksRequestParser.toJson(request, gen);
        }
    }

    static class FetchScanTasksRequestDeserializer<T extends FetchScanTasksRequest>
    extends JsonDeserializer<T> {
        FetchScanTasksRequestDeserializer() {
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)FetchScanTasksRequestParser.fromJson(jsonNode);
        }
    }

    static class PlanTableScanResponseSerializer<T extends PlanTableScanResponse>
    extends JsonSerializer<T> {
        PlanTableScanResponseSerializer() {
        }

        @Override
        public void serialize(T response, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            PlanTableScanResponseParser.toJson(response, gen);
        }
    }

    static class PlanTableScanResponseDeserializer<T extends PlanTableScanResponse>
    extends JsonDeserializer<T> {
        PlanTableScanResponseDeserializer() {
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            TableScanResponseContext scanContext = RESTSerializers.parseScanResponseContext(context);
            return (T)PlanTableScanResponseParser.fromJson(jsonNode, scanContext.getSpecsById(), scanContext.isCaseSensitive());
        }
    }

    static class FetchPlanningResultResponseSerializer<T extends FetchPlanningResultResponse>
    extends JsonSerializer<T> {
        FetchPlanningResultResponseSerializer() {
        }

        @Override
        public void serialize(T response, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            FetchPlanningResultResponseParser.toJson(response, gen);
        }
    }

    static class FetchPlanningResultResponseDeserializer<T extends FetchPlanningResultResponse>
    extends JsonDeserializer<T> {
        FetchPlanningResultResponseDeserializer() {
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            TableScanResponseContext scanContext = RESTSerializers.parseScanResponseContext(context);
            return (T)FetchPlanningResultResponseParser.fromJson(jsonNode, scanContext.getSpecsById(), scanContext.isCaseSensitive());
        }
    }

    static class FetchScanTaskResponseSerializer<T extends FetchScanTasksResponse>
    extends JsonSerializer<T> {
        FetchScanTaskResponseSerializer() {
        }

        @Override
        public void serialize(T response, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            FetchScanTasksResponseParser.toJson(response, gen);
        }
    }

    static class FetchScanTaskResponseDeserializer<T extends FetchScanTasksResponse>
    extends JsonDeserializer<T> {
        FetchScanTaskResponseDeserializer() {
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            TableScanResponseContext scanContext = RESTSerializers.parseScanResponseContext(context);
            return (T)FetchScanTasksResponseParser.fromJson(jsonNode, scanContext.getSpecsById(), scanContext.isCaseSensitive());
        }
    }

    static class LoadCredentialsResponseSerializer<T extends LoadCredentialsResponse>
    extends JsonSerializer<T> {
        LoadCredentialsResponseSerializer() {
        }

        @Override
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            LoadCredentialsResponseParser.toJson(request, gen);
        }
    }

    static class LoadCredentialsResponseDeserializer<T extends LoadCredentialsResponse>
    extends JsonDeserializer<T> {
        LoadCredentialsResponseDeserializer() {
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)LoadCredentialsResponseParser.fromJson(jsonNode);
        }
    }

    static class TableScanResponseContext {
        private final Map<Integer, PartitionSpec> specsById;
        private final boolean caseSensitive;

        TableScanResponseContext(Map<Integer, PartitionSpec> specs, boolean isCaseSensitive) {
            this.specsById = specs;
            this.caseSensitive = isCaseSensitive;
        }

        Map<Integer, PartitionSpec> getSpecsById() {
            return this.specsById;
        }

        boolean isCaseSensitive() {
            return this.caseSensitive;
        }
    }
}

