/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest;

import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateRequirements;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.Endpoint;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.ErrorHandlers;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.UpdateTableRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.LoadViewResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewOperations;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

class RESTViewOperations
implements ViewOperations {
    private final RESTClient client;
    private final String path;
    private final Supplier<Map<String, String>> headers;
    private final Set<Endpoint> endpoints;
    private ViewMetadata current;

    RESTViewOperations(RESTClient client, String path, Supplier<Map<String, String>> headers, ViewMetadata current, Set<Endpoint> endpoints) {
        Preconditions.checkArgument(null != current, "Invalid view metadata: null");
        this.client = client;
        this.path = path;
        this.headers = headers;
        this.current = current;
        this.endpoints = endpoints;
    }

    @Override
    public ViewMetadata current() {
        return this.current;
    }

    @Override
    public ViewMetadata refresh() {
        Endpoint.check(this.endpoints, Endpoint.V1_LOAD_VIEW);
        return this.updateCurrentMetadata(this.client.get(this.path, LoadViewResponse.class, this.headers, ErrorHandlers.viewErrorHandler()));
    }

    @Override
    public void commit(ViewMetadata base, ViewMetadata metadata) {
        Endpoint.check(this.endpoints, Endpoint.V1_UPDATE_VIEW);
        Preconditions.checkState(base != null, "Invalid base metadata: null");
        UpdateTableRequest request = UpdateTableRequest.create(null, UpdateRequirements.forReplaceView(base, metadata.changes()), metadata.changes());
        LoadViewResponse response = this.client.post(this.path, (RESTRequest)request, LoadViewResponse.class, this.headers, ErrorHandlers.viewCommitHandler());
        this.updateCurrentMetadata(response);
    }

    private ViewMetadata updateCurrentMetadata(LoadViewResponse response) {
        if (!Objects.equals(this.current.metadataFileLocation(), response.metadataLocation())) {
            this.current = response.metadata();
        }
        return this.current;
    }
}

