/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth;

import com.dataiku.dss.shadelib.org.apache.iceberg.common.DynConstructors;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.AuthManager;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PropertyUtil;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthManagers {
    private static final Logger LOG = LoggerFactory.getLogger(AuthManagers.class);
    private static final String SIGV4_ENABLED_LEGACY = "rest.sigv4-enabled";

    private AuthManagers() {
    }

    public static AuthManager loadAuthManager(String name, Map<String, String> properties) {
        AuthManager authManager;
        DynConstructors.Ctor ctor;
        String impl;
        String authType;
        if (properties.containsKey(SIGV4_ENABLED_LEGACY)) {
            LOG.warn("The property {} is deprecated and will be removed in a future release. Please use the property {}={} instead.", new Object[]{SIGV4_ENABLED_LEGACY, "rest.auth.type", "sigv4"});
        }
        if (PropertyUtil.propertyAsBoolean(properties, SIGV4_ENABLED_LEGACY, false)) {
            authType = "sigv4";
        } else {
            authType = properties.get("rest.auth.type");
            if (authType == null) {
                boolean hasCredential = properties.containsKey("credential");
                boolean hasToken = properties.containsKey("token");
                if (hasCredential || hasToken) {
                    LOG.warn("Inferring {}={} since property {} was provided. Please explicitly set {} to avoid this warning.", new Object[]{"rest.auth.type", "oauth2", hasCredential ? "credential" : "token", "rest.auth.type"});
                    authType = "oauth2";
                } else {
                    authType = "none";
                }
            }
        }
        AuthManager delegate = null;
        if (authType.equals("sigv4")) {
            String delegateAuthType = properties.getOrDefault("rest.auth.sigv4.delegate-auth-type", "oauth2");
            Preconditions.checkArgument(!"sigv4".equals(delegateAuthType), "Cannot delegate a SigV4 auth manager to another SigV4 auth manager");
            Object newProperties = Maps.newHashMap(properties);
            newProperties.put("rest.auth.type", delegateAuthType);
            newProperties.remove(SIGV4_ENABLED_LEGACY);
            delegate = AuthManagers.loadAuthManager(name, (Map<String, String>)newProperties);
        }
        switch (authType.toLowerCase(Locale.ROOT)) {
            case "none": {
                impl = "com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.NoopAuthManager";
                break;
            }
            case "basic": {
                impl = "com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.BasicAuthManager";
                break;
            }
            case "sigv4": {
                impl = "com.dataiku.dss.shadelibawssk2.org.apache.iceberg.aws.RESTSigV4AuthManager";
                break;
            }
            case "google": {
                impl = "com.dataiku.dss.shadelibgcp.org.apache.iceberg.gcp.auth.GoogleAuthManager";
                break;
            }
            case "oauth2": {
                impl = "com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.OAuth2Manager";
                break;
            }
            default: {
                impl = authType;
            }
        }
        LOG.info("Loading AuthManager implementation: {}", (Object)impl);
        try {
            ctor = DynConstructors.builder(AuthManager.class).loader(AuthManagers.class.getClassLoader()).impl(impl, String.class).impl(impl, String.class, AuthManager.class).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize AuthManager implementation %s: %s", impl, e.getMessage()), e);
        }
        try {
            authManager = (AuthManager)ctor.newInstance(name, delegate);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize AuthManager, %s does not implement AuthManager", impl), e);
        }
        return authManager;
    }
}

