/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth;

import com.dataiku.dss.shadelib.org.apache.iceberg.CatalogProperties;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.SessionCatalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.ResourcePaths;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.AuthConfig;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.AuthSession;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.AuthSessionCache;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.ImmutableAuthConfig;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.OAuth2Util;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.RefreshingAuthManager;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.OAuthTokenResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PropertyUtil;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Manager
extends RefreshingAuthManager {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2Manager.class);
    private static final List<String> TOKEN_PREFERENCE_ORDER = ImmutableList.of("urn:ietf:params:oauth:token-type:id_token", "urn:ietf:params:oauth:token-type:access_token", "urn:ietf:params:oauth:token-type:jwt", "urn:ietf:params:oauth:token-type:saml2", "urn:ietf:params:oauth:token-type:saml1");
    private static final Set<String> TABLE_SESSION_ALLOW_LIST = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("token")).addAll(TOKEN_PREFERENCE_ORDER)).build();
    private final String name;
    private RESTClient refreshClient;
    private long startTimeMillis;
    private OAuthTokenResponse authResponse;
    private AuthSessionCache sessionCache;

    public OAuth2Manager(String managerName) {
        super(managerName + "-token-refresh");
        this.name = managerName;
    }

    @Override
    public OAuth2Util.AuthSession initSession(RESTClient initClient, Map<String, String> properties) {
        OAuth2Manager.warnIfOAuthServerUriNotSet(properties);
        ImmutableAuthConfig config = ImmutableAuthConfig.builder().from(AuthConfig.fromProperties(properties)).keepRefreshed(false).build();
        Map<String, String> headers = OAuth2Util.authHeaders(config.token());
        OAuth2Util.AuthSession session = new OAuth2Util.AuthSession(headers, config);
        if (config.credential() != null && !config.credential().isEmpty()) {
            this.startTimeMillis = System.currentTimeMillis();
            this.authResponse = OAuth2Util.fetchToken(initClient.withAuthSession(session), Map.of(), config.credential(), config.scope(), config.oauth2ServerUri(), config.optionalOAuthParams());
            return OAuth2Util.AuthSession.fromTokenResponse(initClient, null, this.authResponse, this.startTimeMillis, session);
        }
        if (config.token() != null) {
            return OAuth2Util.AuthSession.fromAccessToken(initClient, null, config.token(), null, session);
        }
        return session;
    }

    @Override
    public OAuth2Util.AuthSession catalogSession(RESTClient sharedClient, Map<String, String> properties) {
        this.refreshClient = sharedClient.withAuthSession(AuthSession.EMPTY);
        this.sessionCache = this.newSessionCache(this.name, properties);
        AuthConfig config = AuthConfig.fromProperties(properties);
        Map<String, String> headers = OAuth2Util.authHeaders(config.token());
        OAuth2Util.AuthSession session = new OAuth2Util.AuthSession(headers, config);
        this.keepRefreshed(config.keepRefreshed());
        if (this.authResponse != null) {
            return OAuth2Util.AuthSession.fromTokenResponse(this.refreshClient, this.refreshExecutor(), this.authResponse, this.startTimeMillis, session);
        }
        if (config.token() != null) {
            return OAuth2Util.AuthSession.fromAccessToken(this.refreshClient, this.refreshExecutor(), config.token(), config.expiresAtMillis(), session);
        }
        if (config.credential() != null && !config.credential().isEmpty()) {
            OAuthTokenResponse response = OAuth2Util.fetchToken(sharedClient.withAuthSession(session), Map.of(), config.credential(), config.scope(), config.oauth2ServerUri(), config.optionalOAuthParams());
            return OAuth2Util.AuthSession.fromTokenResponse(this.refreshClient, this.refreshExecutor(), response, System.currentTimeMillis(), session);
        }
        return session;
    }

    @Override
    public OAuth2Util.AuthSession contextualSession(SessionCatalog.SessionContext context, AuthSession parent) {
        return this.maybeCreateChildSession(context.credentials(), context.properties(), ignored -> context.sessionId(), (OAuth2Util.AuthSession)parent);
    }

    @Override
    public OAuth2Util.AuthSession tableSession(TableIdentifier table, Map<String, String> properties, AuthSession parent) {
        return this.maybeCreateChildSession(Maps.filterKeys(properties, TABLE_SESSION_ALLOW_LIST::contains), properties, properties::get, (OAuth2Util.AuthSession)parent);
    }

    @Override
    public AuthSession tableSession(RESTClient sharedClient, Map<String, String> properties) {
        AuthConfig config = AuthConfig.fromProperties(properties);
        Map<String, String> headers = OAuth2Util.authHeaders(config.token());
        OAuth2Util.AuthSession parent = new OAuth2Util.AuthSession(headers, config);
        this.keepRefreshed(config.keepRefreshed());
        if (this.refreshClient == null) {
            this.refreshClient = sharedClient.withAuthSession(parent);
        }
        if (this.sessionCache == null) {
            this.sessionCache = this.newSessionCache(this.name, properties);
        }
        if (config.token() != null) {
            return this.sessionCache.cachedSession(config.token(), k -> this.newSessionFromAccessToken(config.token(), properties, parent));
        }
        if (config.credential() != null && !config.credential().isEmpty()) {
            return this.sessionCache.cachedSession(config.credential(), k -> this.newSessionFromTokenResponse(config, parent));
        }
        return parent;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            AuthSessionCache cache = this.sessionCache;
            this.sessionCache = null;
            if (cache != null) {
                cache.close();
            }
        }
    }

    protected AuthSessionCache newSessionCache(String managerName, Map<String, String> properties) {
        return new AuthSessionCache(managerName, OAuth2Manager.sessionTimeout(properties));
    }

    protected OAuth2Util.AuthSession maybeCreateChildSession(Map<String, String> credentials, Map<String, String> properties, Function<String, String> cacheKeyFunc, OAuth2Util.AuthSession parent) {
        if (credentials != null) {
            if (credentials.containsKey("token")) {
                String token = credentials.get("token");
                return this.sessionCache.cachedSession(cacheKeyFunc.apply("token"), k -> this.newSessionFromAccessToken(token, properties, parent));
            }
            if (credentials.containsKey("credential")) {
                String credential = credentials.get("credential");
                return this.sessionCache.cachedSession(cacheKeyFunc.apply("credential"), k -> this.newSessionFromCredential(credential, parent));
            }
            for (String tokenType : TOKEN_PREFERENCE_ORDER) {
                if (!credentials.containsKey(tokenType)) continue;
                String token = credentials.get(tokenType);
                return this.sessionCache.cachedSession(cacheKeyFunc.apply(tokenType), k -> this.newSessionFromTokenExchange(token, tokenType, parent));
            }
        }
        return parent;
    }

    protected OAuth2Util.AuthSession newSessionFromAccessToken(String token, Map<String, String> properties, OAuth2Util.AuthSession parent) {
        Long expiresAtMillis = AuthConfig.fromProperties(properties).expiresAtMillis();
        return OAuth2Util.AuthSession.fromAccessToken(this.refreshClient, this.refreshExecutor(), token, expiresAtMillis, parent);
    }

    protected OAuth2Util.AuthSession newSessionFromCredential(String credential, OAuth2Util.AuthSession parent) {
        return OAuth2Util.AuthSession.fromCredential(this.refreshClient, this.refreshExecutor(), credential, parent);
    }

    protected OAuth2Util.AuthSession newSessionFromTokenExchange(String token, String tokenType, OAuth2Util.AuthSession parent) {
        return OAuth2Util.AuthSession.fromTokenExchange(this.refreshClient, this.refreshExecutor(), token, tokenType, parent);
    }

    protected OAuth2Util.AuthSession newSessionFromTokenResponse(AuthConfig config, OAuth2Util.AuthSession parent) {
        OAuthTokenResponse response = OAuth2Util.fetchToken(this.refreshClient, Map.of(), config.credential(), config.scope(), config.oauth2ServerUri(), config.optionalOAuthParams());
        return OAuth2Util.AuthSession.fromTokenResponse(this.refreshClient, this.refreshExecutor(), response, System.currentTimeMillis(), parent);
    }

    private static void warnIfOAuthServerUriNotSet(Map<String, String> properties) {
        if (!properties.containsKey("oauth2-server-uri")) {
            boolean hasInitToken;
            String credential = properties.get("credential");
            String initToken = properties.get("token");
            boolean hasCredential = credential != null && !credential.isEmpty();
            boolean bl = hasInitToken = initToken != null;
            if (hasInitToken || hasCredential) {
                LOG.warn("Iceberg REST client is missing the OAuth2 server URI configuration and defaults to {}/{}. This automatic fallback will be removed in a future Iceberg release. It is recommended to configure the OAuth2 endpoint using the '{}' property to be prepared. This warning will disappear if the OAuth2 endpoint is explicitly configured. See https://github.com/apache/iceberg/issues/10537", new Object[]{RESTUtil.stripTrailingSlash(properties.get("uri")), ResourcePaths.tokens(), "oauth2-server-uri"});
            }
        }
    }

    private static Duration sessionTimeout(Map<String, String> props) {
        return Duration.ofMillis(PropertyUtil.propertyAsLong(props, "auth.session-timeout-ms", CatalogProperties.AUTH_SESSION_TIMEOUT_MS_DEFAULT));
    }
}

