/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Joiner;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Splitter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.ErrorHandlers;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.HTTPHeaders;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.HTTPRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.ImmutableHTTPRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.ResourcePaths;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.AuthConfig;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.ImmutableAuthConfig;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.OAuthTokenResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.Pair;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.Tasks;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Util {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2Util.class);
    private static final Pattern VALID_SCOPE_TOKEN = Pattern.compile("^[!-~&&[^\"\\\\]]+$");
    private static final Splitter SCOPE_DELIMITER = Splitter.on(" ");
    private static final Joiner SCOPE_JOINER = Joiner.on(" ");
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_PREFIX = "Bearer ";
    private static final String BASIC_PREFIX = "Basic ";
    private static final Splitter CREDENTIAL_SPLITTER = Splitter.on(":").limit(2).trimResults();
    private static final String GRANT_TYPE = "grant_type";
    private static final String CLIENT_CREDENTIALS = "client_credentials";
    private static final String TOKEN_EXCHANGE = "urn:ietf:params:oauth:grant-type:token-exchange";
    private static final String SCOPE = "scope";
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String SUBJECT_TOKEN = "subject_token";
    private static final String SUBJECT_TOKEN_TYPE = "subject_token_type";
    private static final String ACTOR_TOKEN = "actor_token";
    private static final String ACTOR_TOKEN_TYPE = "actor_token_type";
    private static final Set<String> VALID_TOKEN_TYPES = Sets.newHashSet("urn:ietf:params:oauth:token-type:access_token", "urn:ietf:params:oauth:token-type:refresh_token", "urn:ietf:params:oauth:token-type:id_token", "urn:ietf:params:oauth:token-type:saml1", "urn:ietf:params:oauth:token-type:saml2", "urn:ietf:params:oauth:token-type:jwt");
    private static final String ACCESS_TOKEN = "access_token";
    private static final String TOKEN_TYPE = "token_type";
    private static final String EXPIRES_IN = "expires_in";
    private static final String ISSUED_TOKEN_TYPE = "issued_token_type";

    private OAuth2Util() {
    }

    public static Map<String, String> authHeaders(String token) {
        if (token != null) {
            return ImmutableMap.of(AUTHORIZATION_HEADER, BEARER_PREFIX + token);
        }
        return ImmutableMap.of();
    }

    public static Map<String, String> basicAuthHeaders(String credential) {
        if (credential != null) {
            return ImmutableMap.of(AUTHORIZATION_HEADER, BASIC_PREFIX + Base64.getEncoder().encodeToString(credential.getBytes(StandardCharsets.UTF_8)));
        }
        return ImmutableMap.of();
    }

    public static boolean isValidScopeToken(String scopeToken) {
        return VALID_SCOPE_TOKEN.matcher(scopeToken).matches();
    }

    public static List<String> parseScope(String scope) {
        return SCOPE_DELIMITER.splitToList(scope);
    }

    public static String toScope(Iterable<String> scopes) {
        return SCOPE_JOINER.join(scopes);
    }

    public static Map<String, String> buildOptionalParam(Map<String, String> properties) {
        return OAuth2Util.buildOptionalParam(properties, "catalog");
    }

    public static Map<String, String> buildOptionalParam(Map<String, String> properties, String defaultScope) {
        ImmutableSet<String> optionalParamKeys = ImmutableSet.of("audience", "resource");
        ImmutableMap.Builder<String, String> optionalParamBuilder = ImmutableMap.builder();
        optionalParamBuilder.put(SCOPE, properties.getOrDefault(SCOPE, defaultScope));
        for (String key : optionalParamKeys) {
            String value = properties.get(key);
            if (value == null) continue;
            optionalParamBuilder.put(key, value);
        }
        return optionalParamBuilder.buildKeepingLast();
    }

    private static OAuthTokenResponse refreshToken(RESTClient client, AuthConfig config, Map<String, String> headers, String subjectToken, String subjectTokenType, Map<String, String> optionalOAuthParams) {
        if (config.exchangeEnabled()) {
            Map<String, String> request = OAuth2Util.tokenExchangeRequest(subjectToken, subjectTokenType, config.scope() != null ? ImmutableList.of(config.scope()) : ImmutableList.of(), optionalOAuthParams);
            OAuthTokenResponse response = client.postForm(config.oauth2ServerUri(), request, OAuthTokenResponse.class, headers, ErrorHandlers.oauthErrorHandler());
            response.validate();
            return response;
        }
        if (null == config.credential()) {
            return null;
        }
        return OAuth2Util.fetchToken(client, Map.of(), config.credential(), config.scope(), config.oauth2ServerUri());
    }

    public static OAuthTokenResponse exchangeToken(RESTClient client, Map<String, String> headers, String subjectToken, String subjectTokenType, String actorToken, String actorTokenType, String scope, String oauth2ServerUri, Map<String, String> optionalParams) {
        Map<String, String> request = OAuth2Util.tokenExchangeRequest(subjectToken, subjectTokenType, actorToken, actorTokenType, scope != null ? ImmutableList.of(scope) : ImmutableList.of(), optionalParams);
        OAuthTokenResponse response = client.postForm(oauth2ServerUri, request, OAuthTokenResponse.class, headers, ErrorHandlers.oauthErrorHandler());
        response.validate();
        return response;
    }

    @Deprecated
    public static OAuthTokenResponse exchangeToken(RESTClient client, Map<String, String> headers, String subjectToken, String subjectTokenType, String actorToken, String actorTokenType, String scope) {
        return OAuth2Util.exchangeToken(client, headers, subjectToken, subjectTokenType, actorToken, actorTokenType, scope, ResourcePaths.tokens(), ImmutableMap.of());
    }

    @Deprecated
    public static OAuthTokenResponse exchangeToken(RESTClient client, Map<String, String> headers, String subjectToken, String subjectTokenType, String actorToken, String actorTokenType, String scope, String oauth2ServerUri) {
        return OAuth2Util.exchangeToken(client, headers, subjectToken, subjectTokenType, actorToken, actorTokenType, scope, oauth2ServerUri, ImmutableMap.of());
    }

    public static OAuthTokenResponse fetchToken(RESTClient client, Map<String, String> headers, String credential, String scope, String oauth2ServerUri, Map<String, String> optionalParams) {
        Map<String, String> request = OAuth2Util.clientCredentialsRequest(credential, scope != null ? ImmutableList.of(scope) : ImmutableList.of(), optionalParams);
        OAuthTokenResponse response = client.postForm(oauth2ServerUri, request, OAuthTokenResponse.class, headers, ErrorHandlers.oauthErrorHandler());
        response.validate();
        return response;
    }

    @Deprecated
    public static OAuthTokenResponse fetchToken(RESTClient client, Map<String, String> headers, String credential, String scope) {
        return OAuth2Util.fetchToken(client, headers, credential, scope, ResourcePaths.tokens(), ImmutableMap.of());
    }

    @Deprecated
    public static OAuthTokenResponse fetchToken(RESTClient client, Map<String, String> headers, String credential, String scope, String oauth2ServerUri) {
        return OAuth2Util.fetchToken(client, headers, credential, scope, oauth2ServerUri, ImmutableMap.of());
    }

    private static Map<String, String> tokenExchangeRequest(String subjectToken, String subjectTokenType, List<String> scopes, Map<String, String> optionalOAuthParams) {
        return OAuth2Util.tokenExchangeRequest(subjectToken, subjectTokenType, null, null, scopes, optionalOAuthParams);
    }

    private static Map<String, String> tokenExchangeRequest(String subjectToken, String subjectTokenType, String actorToken, String actorTokenType, List<String> scopes, Map<String, String> optionalParams) {
        Preconditions.checkArgument(VALID_TOKEN_TYPES.contains(subjectTokenType), "Invalid token type: %s", (Object)subjectTokenType);
        Preconditions.checkArgument(actorToken == null || VALID_TOKEN_TYPES.contains(actorTokenType), "Invalid token type: %s", (Object)actorTokenType);
        ImmutableMap.Builder<String, String> formData = ImmutableMap.builder();
        formData.put(GRANT_TYPE, TOKEN_EXCHANGE);
        formData.put(SCOPE, OAuth2Util.toScope(scopes));
        formData.put(SUBJECT_TOKEN, subjectToken);
        formData.put(SUBJECT_TOKEN_TYPE, subjectTokenType);
        if (actorToken != null) {
            formData.put(ACTOR_TOKEN, actorToken);
            formData.put(ACTOR_TOKEN_TYPE, actorTokenType);
        }
        formData.putAll(optionalParams);
        return formData.buildKeepingLast();
    }

    private static Pair<String, String> parseCredential(String credential) {
        Preconditions.checkNotNull(credential, "Invalid credential: null");
        List<String> parts = CREDENTIAL_SPLITTER.splitToList(credential);
        switch (parts.size()) {
            case 2: {
                return Pair.of(parts.get(0), parts.get(1));
            }
            case 1: {
                return Pair.of(null, parts.get(0));
            }
        }
        throw new IllegalArgumentException("Invalid credential: " + credential);
    }

    private static Map<String, String> clientCredentialsRequest(String credential, List<String> scopes, Map<String, String> optionalOAuthParams) {
        Pair<String, String> credentialPair = OAuth2Util.parseCredential(credential);
        return OAuth2Util.clientCredentialsRequest(credentialPair.first(), credentialPair.second(), scopes, optionalOAuthParams);
    }

    private static Map<String, String> clientCredentialsRequest(String clientId, String clientSecret, List<String> scopes, Map<String, String> optionalOAuthParams) {
        ImmutableMap.Builder<String, String> formData = ImmutableMap.builder();
        formData.put(GRANT_TYPE, CLIENT_CREDENTIALS);
        if (clientId != null) {
            formData.put(CLIENT_ID, clientId);
        }
        formData.put(CLIENT_SECRET, clientSecret);
        formData.put(SCOPE, OAuth2Util.toScope(scopes));
        formData.putAll(optionalOAuthParams);
        return formData.buildKeepingLast();
    }

    public static String tokenResponseToJson(OAuthTokenResponse response) {
        return JsonUtil.generate(gen -> OAuth2Util.tokenResponseToJson(response, gen), false);
    }

    public static void tokenResponseToJson(OAuthTokenResponse response, JsonGenerator gen) throws IOException {
        response.validate();
        gen.writeStartObject();
        gen.writeStringField(ACCESS_TOKEN, response.token());
        gen.writeStringField(TOKEN_TYPE, response.tokenType());
        if (response.issuedTokenType() != null) {
            gen.writeStringField(ISSUED_TOKEN_TYPE, response.issuedTokenType());
        }
        if (response.expiresInSeconds() != null) {
            gen.writeNumberField(EXPIRES_IN, response.expiresInSeconds());
        }
        if (response.scopes() != null && !response.scopes().isEmpty()) {
            gen.writeStringField(SCOPE, OAuth2Util.toScope(response.scopes()));
        }
        gen.writeEndObject();
    }

    public static OAuthTokenResponse tokenResponseFromJson(String json) {
        return JsonUtil.parse(json, OAuth2Util::tokenResponseFromJson);
    }

    public static OAuthTokenResponse tokenResponseFromJson(JsonNode json) {
        Preconditions.checkArgument(json.isObject(), "Cannot parse token response from non-object: %s", (Object)json);
        OAuthTokenResponse.Builder builder = OAuthTokenResponse.builder().withToken(JsonUtil.getString(ACCESS_TOKEN, json)).withTokenType(JsonUtil.getString(TOKEN_TYPE, json)).withIssuedTokenType(JsonUtil.getStringOrNull(ISSUED_TOKEN_TYPE, json));
        if (json.has(EXPIRES_IN)) {
            builder.setExpirationInSeconds(JsonUtil.getInt(EXPIRES_IN, json));
        }
        if (json.has(SCOPE)) {
            builder.addScopes(OAuth2Util.parseScope(JsonUtil.getString(SCOPE, json)));
        }
        return builder.build();
    }

    static Long expiresAtMillis(String token) {
        JsonNode node;
        if (null == token) {
            return null;
        }
        List<String> parts = Splitter.on('.').splitToList(token);
        if (parts.size() != 3) {
            return null;
        }
        try {
            node = JsonUtil.mapper().readTree(Base64.getUrlDecoder().decode(parts.get(1)));
        }
        catch (IOException | IllegalArgumentException e) {
            return null;
        }
        Long expiresAtSeconds = JsonUtil.getLongOrNull("exp", node);
        if (expiresAtSeconds != null) {
            return TimeUnit.SECONDS.toMillis(expiresAtSeconds);
        }
        return null;
    }

    public static class AuthSession
    implements com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.AuthSession {
        private static int tokenRefreshNumRetries = 5;
        private static final long MAX_REFRESH_WINDOW_MILLIS = 300000L;
        private static final long MIN_REFRESH_WAIT_MILLIS = 10L;
        private volatile Map<String, String> headers;
        private volatile AuthConfig config;

        public AuthSession(Map<String, String> headers, AuthConfig config) {
            this.headers = ImmutableMap.copyOf(headers);
            this.config = config;
        }

        @Override
        public HTTPRequest authenticate(HTTPRequest request) {
            HTTPHeaders newHeaders = request.headers().putIfAbsent(HTTPHeaders.of(this.headers()));
            return newHeaders.equals(request.headers()) ? request : ImmutableHTTPRequest.builder().from(request).headers(newHeaders).build();
        }

        public Map<String, String> headers() {
            return this.headers;
        }

        public String token() {
            return this.config.token();
        }

        public String tokenType() {
            return this.config.tokenType();
        }

        public Long expiresAtMillis() {
            return this.config.expiresAtMillis();
        }

        public String scope() {
            return this.config.scope();
        }

        public synchronized void stopRefreshing() {
            this.config = ImmutableAuthConfig.copyOf(this.config).withKeepRefreshed(false);
        }

        @Override
        public void close() {
            this.stopRefreshing();
        }

        public String credential() {
            return this.config.credential();
        }

        public String oauth2ServerUri() {
            return this.config.oauth2ServerUri();
        }

        public Map<String, String> optionalOAuthParams() {
            return this.config.optionalOAuthParams();
        }

        public AuthConfig config() {
            return this.config;
        }

        @VisibleForTesting
        static void setTokenRefreshNumRetries(int retries) {
            tokenRefreshNumRetries = retries;
        }

        public static AuthSession empty() {
            return new AuthSession(ImmutableMap.of(), AuthConfig.builder().build());
        }

        public Pair<Integer, TimeUnit> refresh(RESTClient client) {
            if (this.token() != null && this.config.keepRefreshed()) {
                AtomicReference<Object> ref = new AtomicReference<Object>(null);
                boolean isSuccessful = Tasks.foreach(ref).suppressFailureWhenFinished().retry(tokenRefreshNumRetries).onFailure((holder, err) -> {
                    holder.set(this.refreshExpiredToken(client));
                    if (holder.get() == null) {
                        LOG.warn("Failed to refresh token", (Throwable)err);
                    }
                }).exponentialBackoff(100L, 60000L, 1800000L, 2.0).run(holder -> holder.set(this.refreshCurrentToken(client)));
                if (!isSuccessful || ref.get() == null) {
                    return null;
                }
                OAuthTokenResponse response = ref.get();
                this.config = AuthConfig.builder().from(this.config()).token(response.token()).tokenType(response.issuedTokenType()).build();
                Map<String, String> currentHeaders = this.headers;
                this.headers = RESTUtil.merge(currentHeaders, OAuth2Util.authHeaders(this.config.token()));
                if (response.expiresInSeconds() != null) {
                    return Pair.of(response.expiresInSeconds(), TimeUnit.SECONDS);
                }
            }
            return null;
        }

        private OAuthTokenResponse refreshCurrentToken(RESTClient client) {
            if (null != this.expiresAtMillis() && this.expiresAtMillis() <= System.currentTimeMillis()) {
                return this.refreshExpiredToken(client);
            }
            return OAuth2Util.refreshToken(client, this.config, this.headers(), this.token(), this.tokenType(), this.optionalOAuthParams());
        }

        private OAuthTokenResponse refreshExpiredToken(RESTClient client) {
            if (this.credential() == null) {
                return null;
            }
            if (this.config.exchangeEnabled()) {
                Map<String, String> basicHeaders = RESTUtil.merge(this.headers(), OAuth2Util.basicAuthHeaders(this.credential()));
                return OAuth2Util.refreshToken(client, this.config, basicHeaders, this.token(), this.tokenType(), this.optionalOAuthParams());
            }
            return OAuth2Util.fetchToken(client, Map.of(), this.credential(), this.scope(), this.oauth2ServerUri());
        }

        private static void scheduleTokenRefresh(RESTClient client, ScheduledExecutorService executor, AuthSession session, long expiresAtMillis) {
            long expiresInMillis = expiresAtMillis - System.currentTimeMillis();
            long refreshWindowMillis = Math.min(expiresInMillis / 10L, 300000L);
            long waitIntervalMillis = expiresInMillis - refreshWindowMillis;
            long timeToWait = Math.max(waitIntervalMillis, 10L);
            executor.schedule(() -> {
                long refreshStartTime = System.currentTimeMillis();
                Pair<Integer, TimeUnit> expiration = session.refresh(client);
                if (expiration != null) {
                    AuthSession.scheduleTokenRefresh(client, executor, session, refreshStartTime + expiration.second().toMillis(expiration.first().intValue()));
                }
            }, timeToWait, TimeUnit.MILLISECONDS);
        }

        public static AuthSession fromAccessToken(RESTClient client, ScheduledExecutorService executor, String token, Long defaultExpiresAtMillis, AuthSession parent) {
            AuthSession session = new AuthSession(RESTUtil.merge(parent.headers(), OAuth2Util.authHeaders(token)), AuthConfig.builder().from(parent.config()).token(token).tokenType("urn:ietf:params:oauth:token-type:access_token").build());
            long startTimeMillis = System.currentTimeMillis();
            Long expiresAtMillis = session.expiresAtMillis();
            if (null != expiresAtMillis && expiresAtMillis <= startTimeMillis) {
                Pair<Integer, TimeUnit> expiration = session.refresh(client);
                expiresAtMillis = expiration != null ? (null != session.expiresAtMillis() ? session.expiresAtMillis() : Long.valueOf(startTimeMillis + expiration.second().toMillis(expiration.first().intValue()))) : null;
            } else if (null == expiresAtMillis && defaultExpiresAtMillis != null) {
                expiresAtMillis = defaultExpiresAtMillis;
            }
            if (null != executor && null != expiresAtMillis) {
                AuthSession.scheduleTokenRefresh(client, executor, session, expiresAtMillis);
            }
            return session;
        }

        public static AuthSession fromCredential(RESTClient client, ScheduledExecutorService executor, String credential, AuthSession parent) {
            long startTimeMillis = System.currentTimeMillis();
            OAuthTokenResponse response = OAuth2Util.fetchToken(client, parent.headers(), credential, parent.scope(), parent.oauth2ServerUri(), parent.optionalOAuthParams());
            return AuthSession.fromTokenResponse(client, executor, response, startTimeMillis, parent, credential);
        }

        public static AuthSession fromTokenResponse(RESTClient client, ScheduledExecutorService executor, OAuthTokenResponse response, long startTimeMillis, AuthSession parent) {
            return AuthSession.fromTokenResponse(client, executor, response, startTimeMillis, parent, parent.credential());
        }

        private static AuthSession fromTokenResponse(RESTClient client, ScheduledExecutorService executor, OAuthTokenResponse response, long startTimeMillis, AuthSession parent, String credential) {
            AuthSession session;
            Long expiresAtMillis;
            String issuedTokenType = response.issuedTokenType();
            if (issuedTokenType == null) {
                issuedTokenType = "urn:ietf:params:oauth:token-type:access_token";
            }
            if (null == (expiresAtMillis = (session = new AuthSession(RESTUtil.merge(parent.headers(), OAuth2Util.authHeaders(response.token())), AuthConfig.builder().from(parent.config()).token(response.token()).tokenType(issuedTokenType).credential(credential).build())).expiresAtMillis()) && response.expiresInSeconds() != null) {
                expiresAtMillis = startTimeMillis + TimeUnit.SECONDS.toMillis(response.expiresInSeconds().intValue());
            }
            if (null != executor && null != expiresAtMillis) {
                AuthSession.scheduleTokenRefresh(client, executor, session, expiresAtMillis);
            }
            return session;
        }

        public static AuthSession fromTokenExchange(RESTClient client, ScheduledExecutorService executor, String token, String tokenType, AuthSession parent) {
            long startTimeMillis = System.currentTimeMillis();
            OAuthTokenResponse response = OAuth2Util.exchangeToken(client, parent.headers(), token, tokenType, parent.token(), parent.tokenType(), parent.scope(), parent.oauth2ServerUri(), parent.optionalOAuthParams());
            return AuthSession.fromTokenResponse(client, executor, response, startTimeMillis, parent);
        }
    }
}

