/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.CommitTransactionRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.UpdateTableRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.UpdateTableRequestParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;

public class CommitTransactionRequestParser {
    private static final String TABLE_CHANGES = "table-changes";

    private CommitTransactionRequestParser() {
    }

    public static String toJson(CommitTransactionRequest request) {
        return CommitTransactionRequestParser.toJson(request, false);
    }

    public static String toJson(CommitTransactionRequest request, boolean pretty) {
        return JsonUtil.generate(gen -> CommitTransactionRequestParser.toJson(request, gen), pretty);
    }

    public static void toJson(CommitTransactionRequest request, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument(null != request, "Invalid commit transaction request: null");
        gen.writeStartObject();
        gen.writeFieldName(TABLE_CHANGES);
        gen.writeStartArray();
        for (UpdateTableRequest tableChange : request.tableChanges()) {
            UpdateTableRequestParser.toJson(tableChange, gen);
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }

    public static CommitTransactionRequest fromJson(String json) {
        return JsonUtil.parse(json, CommitTransactionRequestParser::fromJson);
    }

    public static CommitTransactionRequest fromJson(JsonNode json) {
        Preconditions.checkArgument(null != json, "Cannot parse commit transaction request from null object");
        ArrayList<UpdateTableRequest> tableChanges = Lists.newArrayList();
        JsonNode changes = JsonUtil.get(TABLE_CHANGES, json);
        Preconditions.checkArgument(changes.isArray(), "Cannot parse commit transaction request from non-array: %s", (Object)changes);
        for (JsonNode node : changes) {
            tableChanges.add(UpdateTableRequestParser.fromJson(node));
        }
        return new CommitTransactionRequest(tableChanges);
    }
}

