/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses;

import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.PlanStatus;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.BaseScanTaskResponse;
import java.util.List;
import java.util.Map;

public class FetchPlanningResultResponse
extends BaseScanTaskResponse {
    private final PlanStatus planStatus;

    private FetchPlanningResultResponse(PlanStatus planStatus, List<String> planTasks, List<FileScanTask> fileScanTasks, List<DeleteFile> deleteFiles, Map<Integer, PartitionSpec> specsById) {
        super(planTasks, fileScanTasks, deleteFiles, specsById);
        this.planStatus = planStatus;
        this.validate();
    }

    public PlanStatus planStatus() {
        return this.planStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(this.planStatus() != null, "Invalid status: null");
        Preconditions.checkArgument(this.planStatus() == PlanStatus.COMPLETED || this.planTasks() == null && this.fileScanTasks() == null, "Invalid response: tasks can only be returned in a 'completed' status");
        if (this.fileScanTasks() == null || this.fileScanTasks().isEmpty()) {
            Preconditions.checkArgument(this.deleteFiles() == null || this.deleteFiles().isEmpty(), "Invalid response: deleteFiles should only be returned with fileScanTasks that reference them");
        }
    }

    public static class Builder
    extends BaseScanTaskResponse.Builder<Builder, FetchPlanningResultResponse> {
        private PlanStatus planStatus;

        private Builder() {
        }

        public Builder withPlanStatus(PlanStatus status) {
            this.planStatus = status;
            return this;
        }

        @Override
        public FetchPlanningResultResponse build() {
            return new FetchPlanningResultResponse(this.planStatus, this.planTasks(), this.fileScanTasks(), this.deleteFiles(), this.specsById());
        }
    }
}

