/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.PlanStatus;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.TableScanResponseParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.FetchPlanningResultResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class FetchPlanningResultResponseParser {
    private static final String PLAN_STATUS = "plan-status";
    private static final String PLAN_TASKS = "plan-tasks";

    private FetchPlanningResultResponseParser() {
    }

    public static String toJson(FetchPlanningResultResponse response) {
        return FetchPlanningResultResponseParser.toJson(response, false);
    }

    public static String toJson(FetchPlanningResultResponse response, boolean pretty) {
        return JsonUtil.generate(gen -> FetchPlanningResultResponseParser.toJson(response, gen), pretty);
    }

    public static void toJson(FetchPlanningResultResponse response, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument(null != response, "Invalid fetchPlanningResult response: null");
        Preconditions.checkArgument(response.specsById() != null || response.fileScanTasks() == null || response.fileScanTasks().isEmpty(), "Cannot serialize fileScanTasks in fetchingPlanningResultResponse without specsById");
        gen.writeStartObject();
        gen.writeStringField(PLAN_STATUS, response.planStatus().status());
        if (response.planTasks() != null) {
            JsonUtil.writeStringArray(PLAN_TASKS, response.planTasks(), gen);
        }
        TableScanResponseParser.serializeScanTasks(response.fileScanTasks(), response.deleteFiles(), response.specsById(), gen);
        gen.writeEndObject();
    }

    @VisibleForTesting
    static FetchPlanningResultResponse fromJson(String json, Map<Integer, PartitionSpec> specsById, boolean caseSensitive) {
        Preconditions.checkArgument(json != null, "Invalid fetchPlanningResult response: null or empty");
        return JsonUtil.parse(json, node -> FetchPlanningResultResponseParser.fromJson(node, specsById, caseSensitive));
    }

    public static FetchPlanningResultResponse fromJson(JsonNode json, Map<Integer, PartitionSpec> specsById, boolean caseSensitive) {
        Preconditions.checkArgument(json != null && !json.isEmpty(), "Invalid fetchPlanningResult response: null or empty");
        PlanStatus planStatus = PlanStatus.fromName(JsonUtil.getString(PLAN_STATUS, json));
        List<String> planTasks = JsonUtil.getStringListOrNull(PLAN_TASKS, json);
        List<DeleteFile> deleteFiles = TableScanResponseParser.parseDeleteFiles(json, specsById);
        List<FileScanTask> fileScanTasks = TableScanResponseParser.parseFileScanTasks(json, deleteFiles, specsById, caseSensitive);
        return ((FetchPlanningResultResponse.Builder)((FetchPlanningResultResponse.Builder)((FetchPlanningResultResponse.Builder)FetchPlanningResultResponse.builder().withPlanStatus(planStatus).withPlanTasks(planTasks)).withFileScanTasks(fileScanTasks)).withDeleteFiles(deleteFiles)).build();
    }
}

