/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses;

import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTResponse;
import java.util.Collection;
import java.util.List;

public class ListNamespacesResponse
implements RESTResponse {
    private List<Namespace> namespaces;
    private String nextPageToken;

    public ListNamespacesResponse() {
    }

    private ListNamespacesResponse(List<Namespace> namespaces, String nextPageToken) {
        this.namespaces = namespaces;
        this.nextPageToken = nextPageToken;
        this.validate();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(this.namespaces != null, "Invalid namespace: null");
    }

    public List<Namespace> namespaces() {
        return this.namespaces != null ? this.namespaces : ImmutableList.of();
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("namespaces", this.namespaces()).add("next-page-token", this.nextPageToken()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<Namespace> namespaces = ImmutableList.builder();
        private String nextPageToken;

        private Builder() {
        }

        public Builder add(Namespace toAdd) {
            Preconditions.checkNotNull(toAdd, "Invalid namespace: null");
            this.namespaces.add((Object)toAdd);
            return this;
        }

        public Builder addAll(Collection<Namespace> toAdd) {
            Preconditions.checkNotNull(toAdd, "Invalid namespace list: null");
            Preconditions.checkArgument(!toAdd.contains(null), "Invalid namespace: null");
            this.namespaces.addAll(toAdd);
            return this;
        }

        public Builder nextPageToken(String pageToken) {
            this.nextPageToken = pageToken;
            return this;
        }

        public ListNamespacesResponse build() {
            return new ListNamespacesResponse((List<Namespace>)((Object)this.namespaces.build()), this.nextPageToken);
        }
    }
}

