/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadataParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.credentials.Credential;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.credentials.CredentialParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.LoadCredentialsResponseParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.LoadTableResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import java.io.IOException;

public class LoadTableResponseParser {
    private static final String METADATA_LOCATION = "metadata-location";
    private static final String METADATA = "metadata";
    private static final String CONFIG = "config";
    private static final String STORAGE_CREDENTIALS = "storage-credentials";

    private LoadTableResponseParser() {
    }

    public static String toJson(LoadTableResponse response) {
        return LoadTableResponseParser.toJson(response, false);
    }

    public static String toJson(LoadTableResponse response, boolean pretty) {
        return JsonUtil.generate(gen -> LoadTableResponseParser.toJson(response, gen), pretty);
    }

    public static void toJson(LoadTableResponse response, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument(null != response, "Invalid load table response: null");
        gen.writeStartObject();
        if (null != response.metadataLocation()) {
            gen.writeStringField(METADATA_LOCATION, response.metadataLocation());
        }
        gen.writeFieldName(METADATA);
        TableMetadataParser.toJson(response.tableMetadata(), gen);
        if (!response.config().isEmpty()) {
            JsonUtil.writeStringMap(CONFIG, response.config(), gen);
        }
        if (!response.credentials().isEmpty()) {
            gen.writeArrayFieldStart(STORAGE_CREDENTIALS);
            for (Credential credential : response.credentials()) {
                CredentialParser.toJson(credential, gen);
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
    }

    public static LoadTableResponse fromJson(String json) {
        return JsonUtil.parse(json, LoadTableResponseParser::fromJson);
    }

    public static LoadTableResponse fromJson(JsonNode json) {
        Preconditions.checkArgument(null != json, "Cannot parse load table response from null object");
        String metadataLocation = null;
        if (json.hasNonNull(METADATA_LOCATION)) {
            metadataLocation = JsonUtil.getString(METADATA_LOCATION, json);
        }
        TableMetadata metadata = TableMetadataParser.fromJson(JsonUtil.get(METADATA, json));
        if (null != metadataLocation) {
            metadata = TableMetadata.buildFrom(metadata).withMetadataLocation(metadataLocation).build();
        }
        LoadTableResponse.Builder builder = LoadTableResponse.builder().withTableMetadata(metadata);
        if (json.hasNonNull(CONFIG)) {
            builder.addAllConfig(JsonUtil.getStringMap(CONFIG, json));
        }
        if (json.hasNonNull(STORAGE_CREDENTIALS)) {
            builder.addAllCredentials(LoadCredentialsResponseParser.fromJson(json).credentials());
        }
        return builder.build();
    }
}

