/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.ErrorResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;

public class OAuthErrorResponseParser {
    private static final String ERROR = "error";
    private static final String ERROR_DESCRIPTION = "error_description";

    private OAuthErrorResponseParser() {
    }

    public static ErrorResponse fromJson(int code, String json) {
        return JsonUtil.parse(json, node -> OAuthErrorResponseParser.fromJson(code, node));
    }

    public static ErrorResponse fromJson(int code, JsonNode jsonNode) {
        Preconditions.checkArgument(jsonNode != null && jsonNode.isObject(), "Cannot parse error response from non-object value: %s", (Object)jsonNode);
        String error = JsonUtil.getString(ERROR, jsonNode);
        String errorDescription = JsonUtil.getStringOrNull(ERROR_DESCRIPTION, jsonNode);
        return ErrorResponse.builder().responseCode(code).withType(error).withMessage(errorDescription).build();
    }
}

