/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses;

import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.OAuth2Util;
import java.util.List;

public class OAuthTokenResponse
implements RESTResponse {
    private final String accessToken;
    private final String issuedTokenType;
    private final String tokenType;
    private final Integer expiresIn;
    private final String scope;

    private OAuthTokenResponse(String accessToken, String issuedTokenType, String tokenType, Integer expiresIn, String scope) {
        this.accessToken = accessToken;
        this.issuedTokenType = issuedTokenType;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
        this.scope = scope;
    }

    @Override
    public void validate() {
        Preconditions.checkNotNull(this.accessToken, "Invalid access token: null");
        Preconditions.checkArgument("bearer".equalsIgnoreCase(this.tokenType) || "N_A".equalsIgnoreCase(this.tokenType), "Unsupported token type: %s (must be \"bearer\" or \"N_A\")", (Object)this.tokenType);
    }

    public String token() {
        return this.accessToken;
    }

    public String issuedTokenType() {
        return this.issuedTokenType;
    }

    public String tokenType() {
        return this.tokenType;
    }

    public Integer expiresInSeconds() {
        return this.expiresIn;
    }

    public List<String> scopes() {
        return this.scope != null ? OAuth2Util.parseScope(this.scope) : ImmutableList.of();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String accessToken;
        private String issuedTokenType;
        private String tokenType;
        private Integer expiresInSeconds;
        private final List<String> scopes = Lists.newArrayList();

        private Builder() {
        }

        public Builder withToken(String token) {
            this.accessToken = token;
            return this;
        }

        public Builder withIssuedTokenType(String issuedType) {
            this.issuedTokenType = issuedType;
            return this;
        }

        public Builder withTokenType(String type) {
            this.tokenType = type;
            return this;
        }

        public Builder setExpirationInSeconds(int durationInSeconds) {
            this.expiresInSeconds = durationInSeconds;
            return this;
        }

        public Builder addScope(String scope) {
            Preconditions.checkArgument(OAuth2Util.isValidScopeToken(scope), "Invalid scope: %s");
            this.scopes.add(scope);
            return this;
        }

        public Builder addScopes(List<String> scope) {
            scope.forEach(this::addScope);
            return this;
        }

        public OAuthTokenResponse build() {
            String scope = this.scopes.isEmpty() ? null : OAuth2Util.toScope(this.scopes);
            return new OAuthTokenResponse(this.accessToken, this.issuedTokenType, this.tokenType, this.expiresInSeconds, scope);
        }
    }
}

