/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.PlanStatus;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.TableScanResponseParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.PlanTableScanResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.VisibleForTesting;

public class PlanTableScanResponseParser {
    private static final String PLAN_STATUS = "plan-status";
    private static final String PLAN_ID = "plan-id";
    private static final String PLAN_TASKS = "plan-tasks";

    private PlanTableScanResponseParser() {
    }

    public static String toJson(PlanTableScanResponse response) {
        return PlanTableScanResponseParser.toJson(response, false);
    }

    public static String toJson(PlanTableScanResponse response, boolean pretty) {
        return JsonUtil.generate(gen -> PlanTableScanResponseParser.toJson(response, gen), pretty);
    }

    public static void toJson(PlanTableScanResponse response, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument(null != response, "Invalid response: planTableScanResponse null");
        Preconditions.checkArgument(response.planStatus() != null, "Invalid response: status can not be null");
        Preconditions.checkArgument(response.specsById() != null, "Cannot serialize planTableScanResponse without specsById");
        gen.writeStartObject();
        gen.writeStringField(PLAN_STATUS, response.planStatus().status());
        if (response.planId() != null) {
            gen.writeStringField(PLAN_ID, response.planId());
        }
        if (response.planTasks() != null) {
            JsonUtil.writeStringArray(PLAN_TASKS, response.planTasks(), gen);
        }
        TableScanResponseParser.serializeScanTasks(response.fileScanTasks(), response.deleteFiles(), response.specsById(), gen);
        gen.writeEndObject();
    }

    @VisibleForTesting
    static PlanTableScanResponse fromJson(String json, Map<Integer, PartitionSpec> specsById, boolean caseSensitive) {
        Preconditions.checkArgument(json != null, "Cannot parse planTableScan response from empty or null object");
        return JsonUtil.parse(json, node -> PlanTableScanResponseParser.fromJson(node, specsById, caseSensitive));
    }

    public static PlanTableScanResponse fromJson(JsonNode json, Map<Integer, PartitionSpec> specsById, boolean caseSensitive) {
        Preconditions.checkArgument(json != null && !json.isEmpty(), "Cannot parse planTableScan response from empty or null object");
        PlanStatus planStatus = PlanStatus.fromName(JsonUtil.getString(PLAN_STATUS, json));
        String planId = JsonUtil.getStringOrNull(PLAN_ID, json);
        List<String> planTasks = JsonUtil.getStringListOrNull(PLAN_TASKS, json);
        List<DeleteFile> deleteFiles = TableScanResponseParser.parseDeleteFiles(json, specsById);
        List<FileScanTask> fileScanTasks = TableScanResponseParser.parseFileScanTasks(json, deleteFiles, specsById, caseSensitive);
        return ((PlanTableScanResponse.Builder)((PlanTableScanResponse.Builder)((PlanTableScanResponse.Builder)PlanTableScanResponse.builder().withPlanId(planId).withPlanStatus(planStatus).withPlanTasks(planTasks)).withFileScanTasks(fileScanTasks)).withDeleteFiles(deleteFiles)).build();
    }
}

