/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.transforms;

import com.dataiku.dss.shadelib.com.google.errorprone.annotations.Immutable;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundPredicate;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundTransform;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.UnboundPredicate;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.ProjectionUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.TimeTransform;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Timestamps;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Transform;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.TransformUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.DateTimeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SerializableFunction;
import java.time.temporal.ChronoUnit;

enum Dates implements Transform<Integer, Integer>
{
    YEAR(ChronoUnit.YEARS, "year"),
    MONTH(ChronoUnit.MONTHS, "month"),
    DAY(ChronoUnit.DAYS, "day");

    private final ChronoUnit granularity;
    private final String name;
    private final Apply apply;

    private Dates(ChronoUnit granularity, String name) {
        this.granularity = granularity;
        this.name = name;
        this.apply = new Apply(granularity);
    }

    @Override
    @Deprecated
    public Integer apply(Integer days) {
        return this.apply.apply(days);
    }

    @Override
    public SerializableFunction<Integer, Integer> bind(Type type) {
        Preconditions.checkArgument(this.canTransform(type), "Cannot bind to unsupported type: %s", (Object)type);
        return this.apply;
    }

    @Override
    public boolean canTransform(Type type) {
        return type.typeId() == Type.TypeID.DATE;
    }

    @Override
    public Type getResultType(Type sourceType) {
        if (this.granularity == ChronoUnit.DAYS) {
            return Types.DateType.get();
        }
        return Types.IntegerType.get();
    }

    ChronoUnit granularity() {
        return this.granularity;
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public boolean satisfiesOrderOf(Transform<?, ?> other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Dates) {
            return TransformUtil.satisfiesOrderOf(this.granularity, ((Dates)other).granularity());
        }
        if (other instanceof Timestamps) {
            return TransformUtil.satisfiesOrderOf(this.granularity, ((Timestamps)other).granularity());
        }
        if (other instanceof TimeTransform) {
            return TransformUtil.satisfiesOrderOf(this.granularity, ((TimeTransform)other).granularity());
        }
        return false;
    }

    @Override
    public UnboundPredicate<Integer> project(String fieldName, BoundPredicate<Integer> pred) {
        if (pred.term() instanceof BoundTransform) {
            return ProjectionUtil.projectTransformPredicate(this, fieldName, pred);
        }
        if (pred.isUnaryPredicate()) {
            return Expressions.predicate(pred.op(), fieldName);
        }
        if (pred.isLiteralPredicate()) {
            UnboundPredicate<Integer> projected = ProjectionUtil.truncateInteger(fieldName, pred.asLiteralPredicate(), this.apply);
            if (this != DAY) {
                return ProjectionUtil.fixInclusiveTimeProjection(projected);
            }
            return projected;
        }
        if (pred.isSetPredicate() && pred.op() == Expression.Operation.IN) {
            UnboundPredicate<Integer> projected = ProjectionUtil.transformSet(fieldName, pred.asSetPredicate(), this.apply);
            if (this != DAY) {
                return ProjectionUtil.fixInclusiveTimeProjection(projected);
            }
            return projected;
        }
        return null;
    }

    @Override
    public UnboundPredicate<Integer> projectStrict(String fieldName, BoundPredicate<Integer> pred) {
        if (pred.term() instanceof BoundTransform) {
            return ProjectionUtil.projectTransformPredicate(this, fieldName, pred);
        }
        if (pred.isUnaryPredicate()) {
            return Expressions.predicate(pred.op(), fieldName);
        }
        if (pred.isLiteralPredicate()) {
            UnboundPredicate<Integer> projected = ProjectionUtil.truncateIntegerStrict(fieldName, pred.asLiteralPredicate(), this.apply);
            if (this != DAY) {
                return ProjectionUtil.fixStrictTimeProjection(projected);
            }
            return projected;
        }
        if (pred.isSetPredicate() && pred.op() == Expression.Operation.NOT_IN) {
            UnboundPredicate<Integer> projected = ProjectionUtil.transformSet(fieldName, pred.asSetPredicate(), this.apply);
            if (this != DAY) {
                return ProjectionUtil.fixStrictTimeProjection(projected);
            }
            return projected;
        }
        return null;
    }

    @Override
    public String toHumanString(Type outputType, Integer value) {
        if (value == null) {
            return "null";
        }
        switch (this.granularity) {
            case YEARS: {
                return TransformUtil.humanYear(value);
            }
            case MONTHS: {
                return TransformUtil.humanMonth(value);
            }
            case DAYS: {
                return TransformUtil.humanDay(value);
            }
        }
        throw new UnsupportedOperationException("Unsupported time unit: " + String.valueOf(this.granularity));
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String dedupName() {
        return "time";
    }

    @Immutable
    static class Apply
    implements SerializableFunction<Integer, Integer> {
        private final ChronoUnit granularity;

        Apply(ChronoUnit granularity) {
            this.granularity = granularity;
        }

        @Override
        public Integer apply(Integer days) {
            if (days == null) {
                return null;
            }
            switch (this.granularity) {
                case YEARS: {
                    return DateTimeUtil.daysToYears(days);
                }
                case MONTHS: {
                    return DateTimeUtil.daysToMonths(days);
                }
                case DAYS: {
                    return days;
                }
            }
            throw new UnsupportedOperationException("Unsupported time unit: " + String.valueOf(this.granularity));
        }
    }
}

