/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.transforms;

import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundPredicate;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundTerm;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundTransform;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.UnboundPredicate;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Dates;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.ProjectionUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Timestamps;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Transform;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.TransformUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SerializableFunction;
import java.time.temporal.ChronoUnit;

abstract class TimeTransform<S>
implements Transform<S, Integer> {
    TimeTransform() {
    }

    protected static <R> R fromSourceType(Type type, R dateResult, R microsResult, R nanosResult) {
        switch (type.typeId()) {
            case DATE: {
                if (dateResult == null) break;
                return dateResult;
            }
            case TIMESTAMP: {
                return microsResult;
            }
            case TIMESTAMP_NANO: {
                return nanosResult;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    protected abstract ChronoUnit granularity();

    protected abstract Transform<S, Integer> toEnum(Type var1);

    @Override
    public SerializableFunction<S, Integer> bind(Type type) {
        return this.toEnum(type).bind(type);
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public boolean satisfiesOrderOf(Transform<?, ?> other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Dates) {
            return TransformUtil.satisfiesOrderOf(this.granularity(), ((Dates)other).granularity());
        }
        if (other instanceof Timestamps) {
            return TransformUtil.satisfiesOrderOf(this.granularity(), ((Timestamps)other).granularity());
        }
        if (other instanceof TimeTransform) {
            return TransformUtil.satisfiesOrderOf(this.granularity(), ((TimeTransform)other).granularity());
        }
        return false;
    }

    @Override
    public boolean canTransform(Type type) {
        return type.typeId() == Type.TypeID.DATE || type.typeId() == Type.TypeID.TIMESTAMP || type.typeId() == Type.TypeID.TIMESTAMP_NANO;
    }

    @Override
    public UnboundPredicate<Integer> project(String name, BoundPredicate<S> predicate) {
        if (predicate.term() instanceof BoundTransform) {
            return ProjectionUtil.projectTransformPredicate(this, name, predicate);
        }
        return this.toEnum(((BoundTerm)predicate.term()).type()).project(name, predicate);
    }

    @Override
    public UnboundPredicate<Integer> projectStrict(String name, BoundPredicate<S> predicate) {
        if (predicate.term() instanceof BoundTransform) {
            return ProjectionUtil.projectTransformPredicate(this, name, predicate);
        }
        return this.toEnum(((BoundTerm)predicate.term()).type()).projectStrict(name, predicate);
    }

    @Override
    public String dedupName() {
        return "time";
    }
}

