/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.types;

import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import java.util.Locale;

public enum EdgeAlgorithm {
    SPHERICAL,
    VINCENTY,
    THOMAS,
    ANDOYER,
    KARNEY;


    public static EdgeAlgorithm fromName(String algorithmName) {
        Preconditions.checkNotNull(algorithmName, "Invalid edge interpolation algorithm: null");
        try {
            return EdgeAlgorithm.valueOf(algorithmName.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid edge interpolation algorithm: %s", algorithmName), e);
        }
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }
}

