/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.util;

import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.StructLikeWrapper;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class StructLikeSet
extends AbstractSet<StructLike>
implements Set<StructLike> {
    private final Types.StructType type;
    private final Set<StructLikeWrapper> wrapperSet;
    private final ThreadLocal<StructLikeWrapper> wrappers;

    public static StructLikeSet create(Types.StructType type) {
        return new StructLikeSet(type);
    }

    private StructLikeSet(Types.StructType type) {
        this.type = type;
        this.wrapperSet = Sets.newHashSet();
        this.wrappers = ThreadLocal.withInitial(() -> StructLikeWrapper.forType(type));
    }

    @Override
    public int size() {
        return this.wrapperSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapperSet.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        if (obj instanceof StructLike || obj == null) {
            StructLikeWrapper wrapper = this.wrappers.get();
            boolean result = this.wrapperSet.contains(wrapper.set((StructLike)obj));
            wrapper.set(null);
            return result;
        }
        return false;
    }

    @Override
    public Iterator<StructLike> iterator() {
        return Iterators.transform(this.wrapperSet.iterator(), StructLikeWrapper::get);
    }

    @Override
    public Object[] toArray() {
        return Iterators.toArray(this.iterator(), StructLike.class);
    }

    @Override
    public <T> T[] toArray(T[] destArray) {
        int size = this.wrapperSet.size();
        if (destArray.length < size) {
            return this.toArray();
        }
        Iterator<StructLike> iter = this.iterator();
        int ind = 0;
        while (iter.hasNext()) {
            destArray[ind] = iter.next();
            ++ind;
        }
        if (destArray.length > size) {
            destArray[size] = null;
        }
        return destArray;
    }

    @Override
    public boolean add(StructLike struct) {
        return this.wrapperSet.add(this.wrappers.get().copyFor(struct));
    }

    @Override
    public boolean remove(Object obj) {
        if (obj instanceof StructLike || obj == null) {
            StructLikeWrapper wrapper = this.wrappers.get();
            boolean result = this.wrapperSet.remove(wrapper.set((StructLike)obj));
            wrapper.set(null);
            return result;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        if (objects != null) {
            return Iterables.all(objects, this::contains);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends StructLike> structs) {
        if (structs != null) {
            return Iterables.addAll(this.wrapperSet, Iterables.transform(structs, struct -> this.wrappers.get().copyFor((StructLike)struct)));
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        throw new UnsupportedOperationException("retailAll is not supported");
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        boolean changed = false;
        if (objects != null) {
            for (Object object : objects) {
                changed |= this.remove(object);
            }
        }
        return changed;
    }

    @Override
    public void clear() {
        this.wrapperSet.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructLikeSet that = (StructLikeSet)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (this.wrapperSet.size() != that.wrapperSet.size()) {
            return false;
        }
        return this.containsAll(that);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.type) + this.wrapperSet.stream().mapToInt(StructLikeWrapper::hashCode).sum();
    }
}

