/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.util;

import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.DuplicateWAPCommitException;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SnapshotUtil;

public class WapUtil {
    private WapUtil() {
    }

    public static String stagedWapId(Snapshot snapshot) {
        return snapshot.summary() != null ? snapshot.summary().get("wap.id") : null;
    }

    public static String publishedWapId(Snapshot snapshot) {
        return snapshot.summary() != null ? snapshot.summary().get("published-wap-id") : null;
    }

    public static String validateWapPublish(TableMetadata current, long wapSnapshotId) {
        Snapshot cherryPickSnapshot = current.snapshot(wapSnapshotId);
        String wapId = WapUtil.stagedWapId(cherryPickSnapshot);
        if (wapId != null && !wapId.isEmpty() && WapUtil.isWapIdPublished(current, wapId)) {
            throw new DuplicateWAPCommitException(wapId);
        }
        return wapId;
    }

    private static boolean isWapIdPublished(TableMetadata current, String wapId) {
        for (long ancestorId : SnapshotUtil.ancestorIds(current.currentSnapshot(), current::snapshot)) {
            Snapshot snapshot = current.snapshot(ancestorId);
            if (!wapId.equals(WapUtil.stagedWapId(snapshot)) && !wapId.equals(WapUtil.publishedWapId(snapshot))) continue;
            return true;
        }
        return false;
    }
}

