/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.variants;

import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.io.BaseEncoding;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ByteBuffers;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.DateTimeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.VariantValue;
import java.nio.ByteBuffer;
import java.util.Objects;

public interface VariantPrimitive<T>
extends VariantValue {
    public T get();

    @Override
    default public VariantPrimitive<?> asPrimitive() {
        return this;
    }

    private String valueAsString() {
        switch (this.type()) {
            case DATE: {
                return DateTimeUtil.daysToIsoDate((Integer)this.get());
            }
            case TIME: {
                return DateTimeUtil.microsToIsoTime((Long)this.get());
            }
            case TIMESTAMPTZ: {
                return DateTimeUtil.microsToIsoTimestamptz((Long)this.get());
            }
            case TIMESTAMPNTZ: {
                return DateTimeUtil.microsToIsoTimestamp((Long)this.get());
            }
            case TIMESTAMPTZ_NANOS: {
                return DateTimeUtil.nanosToIsoTimestamptz((Long)this.get());
            }
            case TIMESTAMPNTZ_NANOS: {
                return DateTimeUtil.nanosToIsoTimestamp((Long)this.get());
            }
            case BINARY: {
                return BaseEncoding.base16().encode(ByteBuffers.toByteArray((ByteBuffer)this.get()));
            }
        }
        return String.valueOf(this.get());
    }

    public static String asString(VariantPrimitive<?> primitive) {
        return "Variant(type=" + String.valueOf((Object)primitive.type()) + ", value=" + primitive.valueAsString() + ")";
    }

    public static int hash(VariantPrimitive<?> self) {
        return Objects.hash(new Object[]{self.type(), self.get()});
    }

    public static boolean equals(VariantPrimitive<?> self, Object obj) {
        if (self == obj) {
            return true;
        }
        if (!(obj instanceof VariantPrimitive)) {
            return false;
        }
        VariantPrimitive other = (VariantPrimitive)obj;
        return Objects.equals((Object)self.type(), (Object)other.type()) && Objects.equals(self.get(), other.get());
    }
}

