/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.wikipedia;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenizerFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.wikipedia.WikipediaTokenizer;
import com.dataiku.dss.shadelib.org.apache.lucene.util.AttributeFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class WikipediaTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "wikipedia";
    public static final String TOKEN_OUTPUT = "tokenOutput";
    public static final String UNTOKENIZED_TYPES = "untokenizedTypes";
    protected final int tokenOutput;
    protected Set<String> untokenizedTypes;

    public WikipediaTokenizerFactory(Map<String, String> args2) {
        super(args2);
        this.tokenOutput = this.getInt(args2, TOKEN_OUTPUT, 0);
        this.untokenizedTypes = this.getSet(args2, UNTOKENIZED_TYPES);
        if (this.untokenizedTypes == null) {
            this.untokenizedTypes = Collections.emptySet();
        }
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public WikipediaTokenizerFactory() {
        throw WikipediaTokenizerFactory.defaultCtorException();
    }

    @Override
    public WikipediaTokenizer create(AttributeFactory factory) {
        return new WikipediaTokenizer(factory, this.tokenOutput, this.untokenizedTypes);
    }
}

