/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.index.QueryTimeout;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BulkScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.LeafCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Bits;
import java.io.IOException;
import java.util.Objects;

final class TimeLimitingBulkScorer
extends BulkScorer {
    static final int INTERVAL = 100;
    private final BulkScorer in;
    private final QueryTimeout queryTimeout;

    public TimeLimitingBulkScorer(BulkScorer bulkScorer, QueryTimeout queryTimeout) {
        this.in = bulkScorer;
        this.queryTimeout = Objects.requireNonNull(queryTimeout);
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min2, int max) throws IOException {
        int interval = 100;
        while (min2 < max) {
            int newMax = (int)Math.min((long)min2 + (long)interval, (long)max);
            int newInterval = interval + (interval >> 1);
            if (interval < newInterval) {
                interval = newInterval;
            }
            if (this.queryTimeout.shouldExit()) {
                throw new TimeExceededException();
            }
            min2 = this.in.score(collector, acceptDocs, min2, newMax);
        }
        return min2;
    }

    @Override
    public long cost() {
        return this.in.cost();
    }

    static class TimeExceededException
    extends RuntimeException {
        private TimeExceededException() {
            super("TimeLimit Exceeded");
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

