/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.store;

import com.dataiku.dss.shadelib.org.apache.lucene.store.DataOutput;
import java.io.Closeable;
import java.io.IOException;

public abstract class IndexOutput
extends DataOutput
implements Closeable {
    private final String resourceDescription;
    private final String name;

    protected IndexOutput(String resourceDescription, String name) {
        if (resourceDescription == null) {
            throw new IllegalArgumentException("resourceDescription must not be null");
        }
        this.resourceDescription = resourceDescription;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public abstract void close() throws IOException;

    public abstract long getFilePointer();

    public abstract long getChecksum() throws IOException;

    public String toString() {
        return this.resourceDescription;
    }

    public final long alignFilePointer(int alignmentBytes) throws IOException {
        long offset = this.getFilePointer();
        long alignedOffset = IndexOutput.alignOffset(offset, alignmentBytes);
        int count = (int)(alignedOffset - offset);
        for (int i = 0; i < count; ++i) {
            this.writeByte((byte)0);
        }
        return alignedOffset;
    }

    public static final long alignOffset(long offset, int alignmentBytes) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset must be positive");
        }
        if (1 != Integer.bitCount(alignmentBytes) || alignmentBytes < 0) {
            throw new IllegalArgumentException("Alignment must be a power of 2");
        }
        return Math.addExact(offset - 1L, (long)alignmentBytes) & (long)(-alignmentBytes);
    }
}

