/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.column.impl;

import com.dataiku.dss.shadelib.org.apache.parquet.VersionParser;
import com.dataiku.dss.shadelib.org.apache.parquet.column.ColumnDescriptor;
import com.dataiku.dss.shadelib.org.apache.parquet.column.impl.ColumnReaderBase;
import com.dataiku.dss.shadelib.org.apache.parquet.column.page.DataPage;
import com.dataiku.dss.shadelib.org.apache.parquet.column.page.PageReader;
import com.dataiku.dss.shadelib.org.apache.parquet.io.api.PrimitiveConverter;
import java.util.PrimitiveIterator;

class SynchronizingColumnReader
extends ColumnReaderBase {
    private final PrimitiveIterator.OfLong rowIndexes;
    private long currentRow;
    private long targetRow;
    private long lastRowInPage;
    private int valuesReadFromPage;

    SynchronizingColumnReader(ColumnDescriptor path, PageReader pageReader, PrimitiveConverter converter, VersionParser.ParsedVersion writerVersion, PrimitiveIterator.OfLong rowIndexes) {
        super(path, pageReader, converter, writerVersion);
        this.rowIndexes = rowIndexes;
        this.targetRow = Long.MIN_VALUE;
        this.consume();
    }

    @Override
    boolean isPageFullyConsumed() {
        return this.getPageValueCount() <= this.valuesReadFromPage || this.lastRowInPage < this.targetRow;
    }

    @Override
    boolean isFullyConsumed() {
        return !this.rowIndexes.hasNext();
    }

    @Override
    boolean skipRL(int rl) {
        ++this.valuesReadFromPage;
        if (rl == 0) {
            ++this.currentRow;
            if (this.currentRow > this.targetRow) {
                this.targetRow = this.rowIndexes.hasNext() ? this.rowIndexes.nextLong() : Long.MAX_VALUE;
            }
        }
        return this.currentRow < this.targetRow;
    }

    @Override
    protected void newPageInitialized(DataPage page) {
        long firstRowIndex = page.getFirstRowIndex().orElseThrow(() -> new IllegalArgumentException("Missing firstRowIndex for synchronizing values"));
        int rowCount = page.getIndexRowCount().orElseThrow(() -> new IllegalArgumentException("Missing rowCount for synchronizing values"));
        this.currentRow = firstRowIndex - 1L;
        this.lastRowInPage = firstRowIndex + (long)rowCount - 1L;
        this.valuesReadFromPage = 0;
    }
}

